// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Plugin certificates information for Service Mesh.
 */
@Fluent
public final class IstioPluginCertificateAuthority {
    /*
     * The resource ID of the Key Vault.
     */
    @JsonProperty(value = "keyVaultId")
    private String keyVaultId;

    /*
     * Intermediate certificate object name in Azure Key Vault.
     */
    @JsonProperty(value = "certObjectName")
    private String certObjectName;

    /*
     * Intermediate certificate private key object name in Azure Key Vault.
     */
    @JsonProperty(value = "keyObjectName")
    private String keyObjectName;

    /*
     * Root certificate object name in Azure Key Vault.
     */
    @JsonProperty(value = "rootCertObjectName")
    private String rootCertObjectName;

    /*
     * Certificate chain object name in Azure Key Vault.
     */
    @JsonProperty(value = "certChainObjectName")
    private String certChainObjectName;

    /**
     * Creates an instance of IstioPluginCertificateAuthority class.
     */
    public IstioPluginCertificateAuthority() {
    }

    /**
     * Get the keyVaultId property: The resource ID of the Key Vault.
     * 
     * @return the keyVaultId value.
     */
    public String keyVaultId() {
        return this.keyVaultId;
    }

    /**
     * Set the keyVaultId property: The resource ID of the Key Vault.
     * 
     * @param keyVaultId the keyVaultId value to set.
     * @return the IstioPluginCertificateAuthority object itself.
     */
    public IstioPluginCertificateAuthority withKeyVaultId(String keyVaultId) {
        this.keyVaultId = keyVaultId;
        return this;
    }

    /**
     * Get the certObjectName property: Intermediate certificate object name in Azure Key Vault.
     * 
     * @return the certObjectName value.
     */
    public String certObjectName() {
        return this.certObjectName;
    }

    /**
     * Set the certObjectName property: Intermediate certificate object name in Azure Key Vault.
     * 
     * @param certObjectName the certObjectName value to set.
     * @return the IstioPluginCertificateAuthority object itself.
     */
    public IstioPluginCertificateAuthority withCertObjectName(String certObjectName) {
        this.certObjectName = certObjectName;
        return this;
    }

    /**
     * Get the keyObjectName property: Intermediate certificate private key object name in Azure Key Vault.
     * 
     * @return the keyObjectName value.
     */
    public String keyObjectName() {
        return this.keyObjectName;
    }

    /**
     * Set the keyObjectName property: Intermediate certificate private key object name in Azure Key Vault.
     * 
     * @param keyObjectName the keyObjectName value to set.
     * @return the IstioPluginCertificateAuthority object itself.
     */
    public IstioPluginCertificateAuthority withKeyObjectName(String keyObjectName) {
        this.keyObjectName = keyObjectName;
        return this;
    }

    /**
     * Get the rootCertObjectName property: Root certificate object name in Azure Key Vault.
     * 
     * @return the rootCertObjectName value.
     */
    public String rootCertObjectName() {
        return this.rootCertObjectName;
    }

    /**
     * Set the rootCertObjectName property: Root certificate object name in Azure Key Vault.
     * 
     * @param rootCertObjectName the rootCertObjectName value to set.
     * @return the IstioPluginCertificateAuthority object itself.
     */
    public IstioPluginCertificateAuthority withRootCertObjectName(String rootCertObjectName) {
        this.rootCertObjectName = rootCertObjectName;
        return this;
    }

    /**
     * Get the certChainObjectName property: Certificate chain object name in Azure Key Vault.
     * 
     * @return the certChainObjectName value.
     */
    public String certChainObjectName() {
        return this.certChainObjectName;
    }

    /**
     * Set the certChainObjectName property: Certificate chain object name in Azure Key Vault.
     * 
     * @param certChainObjectName the certChainObjectName value to set.
     * @return the IstioPluginCertificateAuthority object itself.
     */
    public IstioPluginCertificateAuthority withCertChainObjectName(String certChainObjectName) {
        this.certChainObjectName = certChainObjectName;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
