// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.ProxyResource;
import com.azure.core.management.SystemData;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.containerservice.models.TrustedAccessRoleBindingProvisioningState;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/**
 * Defines binding between a resource and role.
 */
@Fluent
public final class TrustedAccessRoleBindingInner extends ProxyResource {
    /*
     * Properties for trusted access role binding
     */
    @JsonProperty(value = "properties", required = true)
    private TrustedAccessRoleBindingProperties innerProperties = new TrustedAccessRoleBindingProperties();

    /*
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    @JsonProperty(value = "systemData", access = JsonProperty.Access.WRITE_ONLY)
    private SystemData systemData;

    /**
     * Creates an instance of TrustedAccessRoleBindingInner class.
     */
    public TrustedAccessRoleBindingInner() {
    }

    /**
     * Get the innerProperties property: Properties for trusted access role binding.
     *
     * @return the innerProperties value.
     */
    private TrustedAccessRoleBindingProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the systemData property: Azure Resource Manager metadata containing createdBy and modifiedBy information.
     *
     * @return the systemData value.
     */
    public SystemData systemData() {
        return this.systemData;
    }

    /**
     * Get the provisioningState property: The current provisioning state of trusted access role binding.
     *
     * @return the provisioningState value.
     */
    public TrustedAccessRoleBindingProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    /**
     * Get the sourceResourceId property: The ARM resource ID of source resource that trusted access is configured for.
     *
     * @return the sourceResourceId value.
     */
    public String sourceResourceId() {
        return this.innerProperties() == null ? null : this.innerProperties().sourceResourceId();
    }

    /**
     * Set the sourceResourceId property: The ARM resource ID of source resource that trusted access is configured for.
     *
     * @param sourceResourceId the sourceResourceId value to set.
     * @return the TrustedAccessRoleBindingInner object itself.
     */
    public TrustedAccessRoleBindingInner withSourceResourceId(String sourceResourceId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new TrustedAccessRoleBindingProperties();
        }
        this.innerProperties().withSourceResourceId(sourceResourceId);
        return this;
    }

    /**
     * Get the roles property: A list of roles to bind, each item is a resource type qualified role name. For example:
     * 'Microsoft.MachineLearningServices/workspaces/reader'.
     *
     * @return the roles value.
     */
    public List<String> roles() {
        return this.innerProperties() == null ? null : this.innerProperties().roles();
    }

    /**
     * Set the roles property: A list of roles to bind, each item is a resource type qualified role name. For example:
     * 'Microsoft.MachineLearningServices/workspaces/reader'.
     *
     * @param roles the roles value to set.
     * @return the TrustedAccessRoleBindingInner object itself.
     */
    public TrustedAccessRoleBindingInner withRoles(List<String> roles) {
        if (this.innerProperties() == null) {
            this.innerProperties = new TrustedAccessRoleBindingProperties();
        }
        this.innerProperties().withRoles(roles);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property innerProperties in model TrustedAccessRoleBindingInner"));
        } else {
            innerProperties().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(TrustedAccessRoleBindingInner.class);
}
