// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.models;

import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collection;

/**
 * Mode of an ingress gateway.
 */
public final class IstioIngressGatewayMode extends ExpandableStringEnum<IstioIngressGatewayMode> {
    /**
     * Static value External for IstioIngressGatewayMode.
     */
    public static final IstioIngressGatewayMode EXTERNAL = fromString("External");

    /**
     * Static value Internal for IstioIngressGatewayMode.
     */
    public static final IstioIngressGatewayMode INTERNAL = fromString("Internal");

    /**
     * Creates a new instance of IstioIngressGatewayMode value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public IstioIngressGatewayMode() {
    }

    /**
     * Creates or finds a IstioIngressGatewayMode from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding IstioIngressGatewayMode.
     */
    @JsonCreator
    public static IstioIngressGatewayMode fromString(String name) {
        return fromString(name, IstioIngressGatewayMode.class);
    }

    /**
     * Gets known IstioIngressGatewayMode values.
     * 
     * @return known IstioIngressGatewayMode values.
     */
    public static Collection<IstioIngressGatewayMode> values() {
        return values(IstioIngressGatewayMode.class);
    }
}
