// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.containerservice.models.AgentPoolUpgradeProfilePropertiesUpgradesItem;
import com.azure.resourcemanager.containerservice.models.OSType;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/**
 * The list of available upgrade versions.
 */
@Fluent
public final class AgentPoolUpgradeProfileProperties {
    /*
     * The Kubernetes version (major.minor.patch).
     */
    @JsonProperty(value = "kubernetesVersion", required = true)
    private String kubernetesVersion;

    /*
     * OsType to be used to specify os type. Choose from Linux and Windows. Default to Linux.
     */
    @JsonProperty(value = "osType", required = true)
    private OSType osType;

    /*
     * List of orchestrator types and versions available for upgrade.
     */
    @JsonProperty(value = "upgrades")
    private List<AgentPoolUpgradeProfilePropertiesUpgradesItem> upgrades;

    /*
     * The latest AKS supported node image version.
     */
    @JsonProperty(value = "latestNodeImageVersion")
    private String latestNodeImageVersion;

    /**
     * Creates an instance of AgentPoolUpgradeProfileProperties class.
     */
    public AgentPoolUpgradeProfileProperties() {
    }

    /**
     * Get the kubernetesVersion property: The Kubernetes version (major.minor.patch).
     * 
     * @return the kubernetesVersion value.
     */
    public String kubernetesVersion() {
        return this.kubernetesVersion;
    }

    /**
     * Set the kubernetesVersion property: The Kubernetes version (major.minor.patch).
     * 
     * @param kubernetesVersion the kubernetesVersion value to set.
     * @return the AgentPoolUpgradeProfileProperties object itself.
     */
    public AgentPoolUpgradeProfileProperties withKubernetesVersion(String kubernetesVersion) {
        this.kubernetesVersion = kubernetesVersion;
        return this;
    }

    /**
     * Get the osType property: OsType to be used to specify os type. Choose from Linux and Windows. Default to Linux.
     * 
     * @return the osType value.
     */
    public OSType osType() {
        return this.osType;
    }

    /**
     * Set the osType property: OsType to be used to specify os type. Choose from Linux and Windows. Default to Linux.
     * 
     * @param osType the osType value to set.
     * @return the AgentPoolUpgradeProfileProperties object itself.
     */
    public AgentPoolUpgradeProfileProperties withOsType(OSType osType) {
        this.osType = osType;
        return this;
    }

    /**
     * Get the upgrades property: List of orchestrator types and versions available for upgrade.
     * 
     * @return the upgrades value.
     */
    public List<AgentPoolUpgradeProfilePropertiesUpgradesItem> upgrades() {
        return this.upgrades;
    }

    /**
     * Set the upgrades property: List of orchestrator types and versions available for upgrade.
     * 
     * @param upgrades the upgrades value to set.
     * @return the AgentPoolUpgradeProfileProperties object itself.
     */
    public AgentPoolUpgradeProfileProperties
        withUpgrades(List<AgentPoolUpgradeProfilePropertiesUpgradesItem> upgrades) {
        this.upgrades = upgrades;
        return this;
    }

    /**
     * Get the latestNodeImageVersion property: The latest AKS supported node image version.
     * 
     * @return the latestNodeImageVersion value.
     */
    public String latestNodeImageVersion() {
        return this.latestNodeImageVersion;
    }

    /**
     * Set the latestNodeImageVersion property: The latest AKS supported node image version.
     * 
     * @param latestNodeImageVersion the latestNodeImageVersion value to set.
     * @return the AgentPoolUpgradeProfileProperties object itself.
     */
    public AgentPoolUpgradeProfileProperties withLatestNodeImageVersion(String latestNodeImageVersion) {
        this.latestNodeImageVersion = latestNodeImageVersion;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (kubernetesVersion() == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                "Missing required property kubernetesVersion in model AgentPoolUpgradeProfileProperties"));
        }
        if (osType() == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                "Missing required property osType in model AgentPoolUpgradeProfileProperties"));
        }
        if (upgrades() != null) {
            upgrades().forEach(e -> e.validate());
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(AgentPoolUpgradeProfileProperties.class);
}
