/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerservice.models;

import com.azure.resourcemanager.containerservice.models.KubernetesPatchVersion;
import com.azure.resourcemanager.containerservice.models.KubernetesVersionCapabilities;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;

public final class KubernetesVersion {
    @JsonProperty(value="version")
    private String version;
    @JsonProperty(value="capabilities")
    private KubernetesVersionCapabilities capabilities;
    @JsonProperty(value="isDefault")
    private Boolean isDefault;
    @JsonProperty(value="isPreview")
    private Boolean isPreview;
    @JsonProperty(value="patchVersions")
    @JsonInclude(value=JsonInclude.Include.NON_NULL, content=JsonInclude.Include.ALWAYS)
    private Map<String, KubernetesPatchVersion> patchVersions;

    public String version() {
        return this.version;
    }

    public KubernetesVersion withVersion(String version) {
        this.version = version;
        return this;
    }

    public KubernetesVersionCapabilities capabilities() {
        return this.capabilities;
    }

    public KubernetesVersion withCapabilities(KubernetesVersionCapabilities capabilities) {
        this.capabilities = capabilities;
        return this;
    }

    public Boolean isDefault() {
        return this.isDefault;
    }

    public KubernetesVersion withIsDefault(Boolean isDefault) {
        this.isDefault = isDefault;
        return this;
    }

    public Boolean isPreview() {
        return this.isPreview;
    }

    public KubernetesVersion withIsPreview(Boolean isPreview) {
        this.isPreview = isPreview;
        return this;
    }

    public Map<String, KubernetesPatchVersion> patchVersions() {
        return this.patchVersions;
    }

    public KubernetesVersion withPatchVersions(Map<String, KubernetesPatchVersion> patchVersions) {
        this.patchVersions = patchVersions;
        return this;
    }

    public void validate() {
        if (this.capabilities() != null) {
            this.capabilities().validate();
        }
        if (this.patchVersions() != null) {
            this.patchVersions().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
    }
}

