// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.containerservice.fluent.models.TrustedAccessRoleBindingInner;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/**
 * List of trusted access role bindings.
 */
@Fluent
public final class TrustedAccessRoleBindingListResult {
    /*
     * Role binding list
     */
    @JsonProperty(value = "value")
    private List<TrustedAccessRoleBindingInner> value;

    /*
     * Link to next page of resources.
     */
    @JsonProperty(value = "nextLink", access = JsonProperty.Access.WRITE_ONLY)
    private String nextLink;

    /**
     * Creates an instance of TrustedAccessRoleBindingListResult class.
     */
    public TrustedAccessRoleBindingListResult() {
    }

    /**
     * Get the value property: Role binding list.
     * 
     * @return the value value.
     */
    public List<TrustedAccessRoleBindingInner> value() {
        return this.value;
    }

    /**
     * Set the value property: Role binding list.
     * 
     * @param value the value value to set.
     * @return the TrustedAccessRoleBindingListResult object itself.
     */
    public TrustedAccessRoleBindingListResult withValue(List<TrustedAccessRoleBindingInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: Link to next page of resources.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }
}
