// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * VPA (Vertical Pod Autoscaler) settings for the workload auto-scaler profile.
 */
@Fluent
public final class ManagedClusterWorkloadAutoScalerProfileVerticalPodAutoscaler {
    /*
     * Whether to enable VPA. Default value is false.
     */
    @JsonProperty(value = "enabled", required = true)
    private boolean enabled;

    /**
     * Creates an instance of ManagedClusterWorkloadAutoScalerProfileVerticalPodAutoscaler class.
     */
    public ManagedClusterWorkloadAutoScalerProfileVerticalPodAutoscaler() {
    }

    /**
     * Get the enabled property: Whether to enable VPA. Default value is false.
     * 
     * @return the enabled value.
     */
    public boolean enabled() {
        return this.enabled;
    }

    /**
     * Set the enabled property: Whether to enable VPA. Default value is false.
     * 
     * @param enabled the enabled value to set.
     * @return the ManagedClusterWorkloadAutoScalerProfileVerticalPodAutoscaler object itself.
     */
    public ManagedClusterWorkloadAutoScalerProfileVerticalPodAutoscaler withEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
