// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Image Cleaner removes unused images from nodes, freeing up disk space and helping to reduce attack surface area.
 * Here are settings for the security profile.
 */
@Fluent
public final class ManagedClusterSecurityProfileImageCleaner {
    /*
     * Whether to enable Image Cleaner on AKS cluster.
     */
    @JsonProperty(value = "enabled")
    private Boolean enabled;

    /*
     * Image Cleaner scanning interval in hours.
     */
    @JsonProperty(value = "intervalHours")
    private Integer intervalHours;

    /**
     * Creates an instance of ManagedClusterSecurityProfileImageCleaner class.
     */
    public ManagedClusterSecurityProfileImageCleaner() {
    }

    /**
     * Get the enabled property: Whether to enable Image Cleaner on AKS cluster.
     * 
     * @return the enabled value.
     */
    public Boolean enabled() {
        return this.enabled;
    }

    /**
     * Set the enabled property: Whether to enable Image Cleaner on AKS cluster.
     * 
     * @param enabled the enabled value to set.
     * @return the ManagedClusterSecurityProfileImageCleaner object itself.
     */
    public ManagedClusterSecurityProfileImageCleaner withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    /**
     * Get the intervalHours property: Image Cleaner scanning interval in hours.
     * 
     * @return the intervalHours value.
     */
    public Integer intervalHours() {
        return this.intervalHours;
    }

    /**
     * Set the intervalHours property: Image Cleaner scanning interval in hours.
     * 
     * @param intervalHours the intervalHours value to set.
     * @return the ManagedClusterSecurityProfileImageCleaner object itself.
     */
    public ManagedClusterSecurityProfileImageCleaner withIntervalHours(Integer intervalHours) {
        this.intervalHours = intervalHours;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
