// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/**
 * The list of available upgrade versions.
 */
@Fluent
public final class ManagedClusterPoolUpgradeProfile {
    /*
     * The Kubernetes version (major.minor.patch).
     */
    @JsonProperty(value = "kubernetesVersion", required = true)
    private String kubernetesVersion;

    /*
     * The Agent Pool name.
     */
    @JsonProperty(value = "name")
    private String name;

    /*
     * OsType to be used to specify os type. Choose from Linux and Windows. Default to Linux.
     */
    @JsonProperty(value = "osType", required = true)
    private OSType osType;

    /*
     * List of orchestrator types and versions available for upgrade.
     */
    @JsonProperty(value = "upgrades")
    private List<ManagedClusterPoolUpgradeProfileUpgradesItem> upgrades;

    /**
     * Creates an instance of ManagedClusterPoolUpgradeProfile class.
     */
    public ManagedClusterPoolUpgradeProfile() {
    }

    /**
     * Get the kubernetesVersion property: The Kubernetes version (major.minor.patch).
     * 
     * @return the kubernetesVersion value.
     */
    public String kubernetesVersion() {
        return this.kubernetesVersion;
    }

    /**
     * Set the kubernetesVersion property: The Kubernetes version (major.minor.patch).
     * 
     * @param kubernetesVersion the kubernetesVersion value to set.
     * @return the ManagedClusterPoolUpgradeProfile object itself.
     */
    public ManagedClusterPoolUpgradeProfile withKubernetesVersion(String kubernetesVersion) {
        this.kubernetesVersion = kubernetesVersion;
        return this;
    }

    /**
     * Get the name property: The Agent Pool name.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: The Agent Pool name.
     * 
     * @param name the name value to set.
     * @return the ManagedClusterPoolUpgradeProfile object itself.
     */
    public ManagedClusterPoolUpgradeProfile withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the osType property: OsType to be used to specify os type. Choose from Linux and Windows. Default to Linux.
     * 
     * @return the osType value.
     */
    public OSType osType() {
        return this.osType;
    }

    /**
     * Set the osType property: OsType to be used to specify os type. Choose from Linux and Windows. Default to Linux.
     * 
     * @param osType the osType value to set.
     * @return the ManagedClusterPoolUpgradeProfile object itself.
     */
    public ManagedClusterPoolUpgradeProfile withOsType(OSType osType) {
        this.osType = osType;
        return this;
    }

    /**
     * Get the upgrades property: List of orchestrator types and versions available for upgrade.
     * 
     * @return the upgrades value.
     */
    public List<ManagedClusterPoolUpgradeProfileUpgradesItem> upgrades() {
        return this.upgrades;
    }

    /**
     * Set the upgrades property: List of orchestrator types and versions available for upgrade.
     * 
     * @param upgrades the upgrades value to set.
     * @return the ManagedClusterPoolUpgradeProfile object itself.
     */
    public ManagedClusterPoolUpgradeProfile withUpgrades(List<ManagedClusterPoolUpgradeProfileUpgradesItem> upgrades) {
        this.upgrades = upgrades;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (kubernetesVersion() == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                "Missing required property kubernetesVersion in model ManagedClusterPoolUpgradeProfile"));
        }
        if (osType() == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                "Missing required property osType in model ManagedClusterPoolUpgradeProfile"));
        }
        if (upgrades() != null) {
            upgrades().forEach(e -> e.validate());
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(ManagedClusterPoolUpgradeProfile.class);
}
