// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.LocalDate;
import java.util.List;

/**
 * Maintenance window used to configure scheduled auto-upgrade for a Managed Cluster.
 */
@Fluent
public final class MaintenanceWindow {
    /*
     * Recurrence schedule for the maintenance window.
     */
    @JsonProperty(value = "schedule", required = true)
    private Schedule schedule;

    /*
     * Length of maintenance window range from 4 to 24 hours.
     */
    @JsonProperty(value = "durationHours", required = true)
    private int durationHours;

    /*
     * The UTC offset in format +/-HH:mm. For example, '+05:30' for IST and '-07:00' for PST. If not specified, the
     * default is '+00:00'.
     */
    @JsonProperty(value = "utcOffset")
    private String utcOffset;

    /*
     * The date the maintenance window activates. If the current date is before this date, the maintenance window is
     * inactive and will not be used for upgrades. If not specified, the maintenance window will be active right away.
     */
    @JsonProperty(value = "startDate")
    private LocalDate startDate;

    /*
     * The start time of the maintenance window. Accepted values are from '00:00' to '23:59'. 'utcOffset' applies to
     * this field. For example: '02:00' with 'utcOffset: +02:00' means UTC time '00:00'.
     */
    @JsonProperty(value = "startTime", required = true)
    private String startTime;

    /*
     * Date ranges on which upgrade is not allowed. 'utcOffset' applies to this field. For example, with 'utcOffset:
     * +02:00' and 'dateSpan' being '2022-12-23' to '2023-01-03', maintenance will be blocked from '2022-12-22 22:00'
     * to '2023-01-03 22:00' in UTC time.
     */
    @JsonProperty(value = "notAllowedDates")
    private List<DateSpan> notAllowedDates;

    /**
     * Creates an instance of MaintenanceWindow class.
     */
    public MaintenanceWindow() {
    }

    /**
     * Get the schedule property: Recurrence schedule for the maintenance window.
     * 
     * @return the schedule value.
     */
    public Schedule schedule() {
        return this.schedule;
    }

    /**
     * Set the schedule property: Recurrence schedule for the maintenance window.
     * 
     * @param schedule the schedule value to set.
     * @return the MaintenanceWindow object itself.
     */
    public MaintenanceWindow withSchedule(Schedule schedule) {
        this.schedule = schedule;
        return this;
    }

    /**
     * Get the durationHours property: Length of maintenance window range from 4 to 24 hours.
     * 
     * @return the durationHours value.
     */
    public int durationHours() {
        return this.durationHours;
    }

    /**
     * Set the durationHours property: Length of maintenance window range from 4 to 24 hours.
     * 
     * @param durationHours the durationHours value to set.
     * @return the MaintenanceWindow object itself.
     */
    public MaintenanceWindow withDurationHours(int durationHours) {
        this.durationHours = durationHours;
        return this;
    }

    /**
     * Get the utcOffset property: The UTC offset in format +/-HH:mm. For example, '+05:30' for IST and '-07:00' for
     * PST. If not specified, the default is '+00:00'.
     * 
     * @return the utcOffset value.
     */
    public String utcOffset() {
        return this.utcOffset;
    }

    /**
     * Set the utcOffset property: The UTC offset in format +/-HH:mm. For example, '+05:30' for IST and '-07:00' for
     * PST. If not specified, the default is '+00:00'.
     * 
     * @param utcOffset the utcOffset value to set.
     * @return the MaintenanceWindow object itself.
     */
    public MaintenanceWindow withUtcOffset(String utcOffset) {
        this.utcOffset = utcOffset;
        return this;
    }

    /**
     * Get the startDate property: The date the maintenance window activates. If the current date is before this date,
     * the maintenance window is inactive and will not be used for upgrades. If not specified, the maintenance window
     * will be active right away.
     * 
     * @return the startDate value.
     */
    public LocalDate startDate() {
        return this.startDate;
    }

    /**
     * Set the startDate property: The date the maintenance window activates. If the current date is before this date,
     * the maintenance window is inactive and will not be used for upgrades. If not specified, the maintenance window
     * will be active right away.
     * 
     * @param startDate the startDate value to set.
     * @return the MaintenanceWindow object itself.
     */
    public MaintenanceWindow withStartDate(LocalDate startDate) {
        this.startDate = startDate;
        return this;
    }

    /**
     * Get the startTime property: The start time of the maintenance window. Accepted values are from '00:00' to
     * '23:59'. 'utcOffset' applies to this field. For example: '02:00' with 'utcOffset: +02:00' means UTC time
     * '00:00'.
     * 
     * @return the startTime value.
     */
    public String startTime() {
        return this.startTime;
    }

    /**
     * Set the startTime property: The start time of the maintenance window. Accepted values are from '00:00' to
     * '23:59'. 'utcOffset' applies to this field. For example: '02:00' with 'utcOffset: +02:00' means UTC time
     * '00:00'.
     * 
     * @param startTime the startTime value to set.
     * @return the MaintenanceWindow object itself.
     */
    public MaintenanceWindow withStartTime(String startTime) {
        this.startTime = startTime;
        return this;
    }

    /**
     * Get the notAllowedDates property: Date ranges on which upgrade is not allowed. 'utcOffset' applies to this
     * field. For example, with 'utcOffset: +02:00' and 'dateSpan' being '2022-12-23' to '2023-01-03', maintenance will
     * be blocked from '2022-12-22 22:00' to '2023-01-03 22:00' in UTC time.
     * 
     * @return the notAllowedDates value.
     */
    public List<DateSpan> notAllowedDates() {
        return this.notAllowedDates;
    }

    /**
     * Set the notAllowedDates property: Date ranges on which upgrade is not allowed. 'utcOffset' applies to this
     * field. For example, with 'utcOffset: +02:00' and 'dateSpan' being '2022-12-23' to '2023-01-03', maintenance will
     * be blocked from '2022-12-22 22:00' to '2023-01-03 22:00' in UTC time.
     * 
     * @param notAllowedDates the notAllowedDates value to set.
     * @return the MaintenanceWindow object itself.
     */
    public MaintenanceWindow withNotAllowedDates(List<DateSpan> notAllowedDates) {
        this.notAllowedDates = notAllowedDates;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (schedule() == null) {
            throw LOGGER.logExceptionAsError(
                new IllegalArgumentException("Missing required property schedule in model MaintenanceWindow"));
        } else {
            schedule().validate();
        }
        if (startTime() == null) {
            throw LOGGER.logExceptionAsError(
                new IllegalArgumentException("Missing required property startTime in model MaintenanceWindow"));
        }
        if (notAllowedDates() != null) {
            notAllowedDates().forEach(e -> e.validate());
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(MaintenanceWindow.class);
}
