// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/**
 * Version information about a product/service that is compatible with a service mesh revision.
 */
@Fluent
public final class CompatibleVersions {
    /*
     * The product/service name.
     */
    @JsonProperty(value = "name")
    private String name;

    /*
     * Product/service versions compatible with a service mesh add-on revision.
     */
    @JsonProperty(value = "versions")
    private List<String> versions;

    /**
     * Creates an instance of CompatibleVersions class.
     */
    public CompatibleVersions() {
    }

    /**
     * Get the name property: The product/service name.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: The product/service name.
     * 
     * @param name the name value to set.
     * @return the CompatibleVersions object itself.
     */
    public CompatibleVersions withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the versions property: Product/service versions compatible with a service mesh add-on revision.
     * 
     * @return the versions value.
     */
    public List<String> versions() {
        return this.versions;
    }

    /**
     * Set the versions property: Product/service versions compatible with a service mesh add-on revision.
     * 
     * @param versions the versions value to set.
     * @return the CompatibleVersions object itself.
     */
    public CompatibleVersions withVersions(List<String> versions) {
        this.versions = versions;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
