// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/**
 * Network settings of an agent pool.
 */
@Fluent
public final class AgentPoolNetworkProfile {
    /*
     * IPTags of instance-level public IPs.
     */
    @JsonProperty(value = "nodePublicIPTags")
    private List<IpTag> nodePublicIpTags;

    /*
     * The port ranges that are allowed to access. The specified ranges are allowed to overlap.
     */
    @JsonProperty(value = "allowedHostPorts")
    private List<PortRange> allowedHostPorts;

    /*
     * The IDs of the application security groups which agent pool will associate when created.
     */
    @JsonProperty(value = "applicationSecurityGroups")
    private List<String> applicationSecurityGroups;

    /**
     * Creates an instance of AgentPoolNetworkProfile class.
     */
    public AgentPoolNetworkProfile() {
    }

    /**
     * Get the nodePublicIpTags property: IPTags of instance-level public IPs.
     * 
     * @return the nodePublicIpTags value.
     */
    public List<IpTag> nodePublicIpTags() {
        return this.nodePublicIpTags;
    }

    /**
     * Set the nodePublicIpTags property: IPTags of instance-level public IPs.
     * 
     * @param nodePublicIpTags the nodePublicIpTags value to set.
     * @return the AgentPoolNetworkProfile object itself.
     */
    public AgentPoolNetworkProfile withNodePublicIpTags(List<IpTag> nodePublicIpTags) {
        this.nodePublicIpTags = nodePublicIpTags;
        return this;
    }

    /**
     * Get the allowedHostPorts property: The port ranges that are allowed to access. The specified ranges are allowed
     * to overlap.
     * 
     * @return the allowedHostPorts value.
     */
    public List<PortRange> allowedHostPorts() {
        return this.allowedHostPorts;
    }

    /**
     * Set the allowedHostPorts property: The port ranges that are allowed to access. The specified ranges are allowed
     * to overlap.
     * 
     * @param allowedHostPorts the allowedHostPorts value to set.
     * @return the AgentPoolNetworkProfile object itself.
     */
    public AgentPoolNetworkProfile withAllowedHostPorts(List<PortRange> allowedHostPorts) {
        this.allowedHostPorts = allowedHostPorts;
        return this;
    }

    /**
     * Get the applicationSecurityGroups property: The IDs of the application security groups which agent pool will
     * associate when created.
     * 
     * @return the applicationSecurityGroups value.
     */
    public List<String> applicationSecurityGroups() {
        return this.applicationSecurityGroups;
    }

    /**
     * Set the applicationSecurityGroups property: The IDs of the application security groups which agent pool will
     * associate when created.
     * 
     * @param applicationSecurityGroups the applicationSecurityGroups value to set.
     * @return the AgentPoolNetworkProfile object itself.
     */
    public AgentPoolNetworkProfile withApplicationSecurityGroups(List<String> applicationSecurityGroups) {
        this.applicationSecurityGroups = applicationSecurityGroups;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (nodePublicIpTags() != null) {
            nodePublicIpTags().forEach(e -> e.validate());
        }
        if (allowedHostPorts() != null) {
            allowedHostPorts().forEach(e -> e.validate());
        }
    }
}
