// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.containerservice.models.AgentPoolMode;
import com.azure.resourcemanager.containerservice.models.AgentPoolNetworkProfile;
import com.azure.resourcemanager.containerservice.models.AgentPoolType;
import com.azure.resourcemanager.containerservice.models.AgentPoolUpgradeSettings;
import com.azure.resourcemanager.containerservice.models.AgentPoolWindowsProfile;
import com.azure.resourcemanager.containerservice.models.CreationData;
import com.azure.resourcemanager.containerservice.models.GpuInstanceProfile;
import com.azure.resourcemanager.containerservice.models.KubeletConfig;
import com.azure.resourcemanager.containerservice.models.KubeletDiskType;
import com.azure.resourcemanager.containerservice.models.LinuxOSConfig;
import com.azure.resourcemanager.containerservice.models.OSDiskType;
import com.azure.resourcemanager.containerservice.models.OSSku;
import com.azure.resourcemanager.containerservice.models.OSType;
import com.azure.resourcemanager.containerservice.models.PowerState;
import com.azure.resourcemanager.containerservice.models.ScaleDownMode;
import com.azure.resourcemanager.containerservice.models.ScaleSetEvictionPolicy;
import com.azure.resourcemanager.containerservice.models.ScaleSetPriority;
import com.azure.resourcemanager.containerservice.models.WorkloadRuntime;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;

/**
 * Properties for the container service agent pool profile.
 */
@Fluent
public class ManagedClusterAgentPoolProfileProperties {
    /*
     * Number of agents (VMs) to host docker containers. Allowed values must be in the range of 0 to 1000 (inclusive)
     * for user pools and in the range of 1 to 1000 (inclusive) for system pools. The default value is 1.
     */
    @JsonProperty(value = "count")
    private Integer count;

    /*
     * The size of the agent pool VMs.
     * 
     * VM size availability varies by region. If a node contains insufficient compute resources (memory, cpu, etc) pods
     * might fail to run correctly. For more details on restricted VM sizes, see:
     * https://docs.microsoft.com/azure/aks/quotas-skus-regions
     */
    @JsonProperty(value = "vmSize")
    private String vmSize;

    /*
     * OS Disk Size in GB to be used to specify the disk size for every machine in the master/agent pool. If you
     * specify 0, it will apply the default osDisk size according to the vmSize specified.
     */
    @JsonProperty(value = "osDiskSizeGB")
    private Integer osDiskSizeGB;

    /*
     * The OS disk type to be used for machines in the agent pool.
     * 
     * The default is 'Ephemeral' if the VM supports it and has a cache disk larger than the requested OSDiskSizeGB.
     * Otherwise, defaults to 'Managed'. May not be changed after creation. For more information see [Ephemeral
     * OS](https://docs.microsoft.com/azure/aks/cluster-configuration#ephemeral-os).
     */
    @JsonProperty(value = "osDiskType")
    private OSDiskType osDiskType;

    /*
     * Determines the placement of emptyDir volumes, container runtime data root, and Kubelet ephemeral storage.
     */
    @JsonProperty(value = "kubeletDiskType")
    private KubeletDiskType kubeletDiskType;

    /*
     * Determines the type of workload a node can run.
     */
    @JsonProperty(value = "workloadRuntime")
    private WorkloadRuntime workloadRuntime;

    /*
     * The ID of the subnet which agent pool nodes and optionally pods will join on startup.
     * 
     * If this is not specified, a VNET and subnet will be generated and used. If no podSubnetID is specified, this
     * applies to nodes and pods, otherwise it applies to just nodes. This is of the form:
     * /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworks/{
     * virtualNetworkName}/subnets/{subnetName}
     */
    @JsonProperty(value = "vnetSubnetID")
    private String vnetSubnetId;

    /*
     * The ID of the subnet which pods will join when launched.
     * 
     * If omitted, pod IPs are statically assigned on the node subnet (see vnetSubnetID for more details). This is of
     * the form:
     * /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworks/{
     * virtualNetworkName}/subnets/{subnetName}
     */
    @JsonProperty(value = "podSubnetID")
    private String podSubnetId;

    /*
     * The maximum number of pods that can run on a node.
     */
    @JsonProperty(value = "maxPods")
    private Integer maxPods;

    /*
     * OsType to be used to specify os type. Choose from Linux and Windows. Default to Linux.
     */
    @JsonProperty(value = "osType")
    private OSType osType;

    /*
     * Specifies the OS SKU used by the agent pool. The default is Ubuntu if OSType is Linux. The default is
     * Windows2019 when Kubernetes <= 1.24 or Windows2022 when Kubernetes >= 1.25 if OSType is Windows.
     */
    @JsonProperty(value = "osSKU")
    private OSSku osSku;

    /*
     * The maximum number of nodes for auto-scaling
     */
    @JsonProperty(value = "maxCount")
    private Integer maxCount;

    /*
     * The minimum number of nodes for auto-scaling
     */
    @JsonProperty(value = "minCount")
    private Integer minCount;

    /*
     * Whether to enable auto-scaler
     */
    @JsonProperty(value = "enableAutoScaling")
    private Boolean enableAutoScaling;

    /*
     * This also effects the cluster autoscaler behavior. If not specified, it defaults to Delete.
     */
    @JsonProperty(value = "scaleDownMode")
    private ScaleDownMode scaleDownMode;

    /*
     * The type of Agent Pool.
     */
    @JsonProperty(value = "type")
    private AgentPoolType type;

    /*
     * The mode of an agent pool.
     * 
     * A cluster must have at least one 'System' Agent Pool at all times. For additional information on agent pool
     * restrictions and best practices, see: https://docs.microsoft.com/azure/aks/use-system-pools
     */
    @JsonProperty(value = "mode")
    private AgentPoolMode mode;

    /*
     * The version of Kubernetes specified by the user.
     * 
     * Both patch version <major.minor.patch> (e.g. 1.20.13) and <major.minor> (e.g. 1.20) are supported. When
     * <major.minor> is specified, the latest supported GA patch version is chosen automatically. Updating the cluster
     * with the same <major.minor> once it has been created (e.g. 1.14.x -> 1.14) will not trigger an upgrade, even if
     * a newer patch version is available. As a best practice, you should upgrade all node pools in an AKS cluster to
     * the same Kubernetes version. The node pool version must have the same major version as the control plane. The
     * node pool minor version must be within two minor versions of the control plane version. The node pool version
     * cannot be greater than the control plane version. For more information see [upgrading a node
     * pool](https://docs.microsoft.com/azure/aks/use-multiple-node-pools#upgrade-a-node-pool).
     */
    @JsonProperty(value = "orchestratorVersion")
    private String orchestratorVersion;

    /*
     * The version of Kubernetes the Agent Pool is running.
     * 
     * If orchestratorVersion is a fully specified version <major.minor.patch>, this field will be exactly equal to it.
     * If orchestratorVersion is <major.minor>, this field will contain the full <major.minor.patch> version being
     * used.
     */
    @JsonProperty(value = "currentOrchestratorVersion", access = JsonProperty.Access.WRITE_ONLY)
    private String currentOrchestratorVersion;

    /*
     * The version of node image
     */
    @JsonProperty(value = "nodeImageVersion", access = JsonProperty.Access.WRITE_ONLY)
    private String nodeImageVersion;

    /*
     * Settings for upgrading the agentpool
     */
    @JsonProperty(value = "upgradeSettings")
    private AgentPoolUpgradeSettings upgradeSettings;

    /*
     * The current deployment or provisioning state.
     */
    @JsonProperty(value = "provisioningState", access = JsonProperty.Access.WRITE_ONLY)
    private String provisioningState;

    /*
     * When an Agent Pool is first created it is initially Running. The Agent Pool can be stopped by setting this field
     * to Stopped. A stopped Agent Pool stops all of its VMs and does not accrue billing charges. An Agent Pool can
     * only be stopped if it is Running and provisioning state is Succeeded
     */
    @JsonProperty(value = "powerState")
    private PowerState powerState;

    /*
     * The list of Availability zones to use for nodes. This can only be specified if the AgentPoolType property is
     * 'VirtualMachineScaleSets'.
     */
    @JsonProperty(value = "availabilityZones")
    private List<String> availabilityZones;

    /*
     * Whether each node is allocated its own public IP.
     * 
     * Some scenarios may require nodes in a node pool to receive their own dedicated public IP addresses. A common
     * scenario is for gaming workloads, where a console needs to make a direct connection to a cloud virtual machine
     * to minimize hops. For more information see [assigning a public IP per
     * node](https://docs.microsoft.com/azure/aks/use-multiple-node-pools#assign-a-public-ip-per-node-for-your-node-
     * pools).
     * The default is false.
     */
    @JsonProperty(value = "enableNodePublicIP")
    private Boolean enableNodePublicIp;

    /*
     * The public IP prefix ID which VM nodes should use IPs from.
     * 
     * This is of the form:
     * /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/publicIPPrefixes/{
     * publicIPPrefixName}
     */
    @JsonProperty(value = "nodePublicIPPrefixID")
    private String nodePublicIpPrefixId;

    /*
     * The Virtual Machine Scale Set priority. If not specified, the default is 'Regular'.
     */
    @JsonProperty(value = "scaleSetPriority")
    private ScaleSetPriority scaleSetPriority;

    /*
     * The Virtual Machine Scale Set eviction policy.
     * 
     * This cannot be specified unless the scaleSetPriority is 'Spot'. If not specified, the default is 'Delete'.
     */
    @JsonProperty(value = "scaleSetEvictionPolicy")
    private ScaleSetEvictionPolicy scaleSetEvictionPolicy;

    /*
     * The max price (in US Dollars) you are willing to pay for spot instances. Possible values are any decimal value
     * greater than zero or -1 which indicates default price to be up-to on-demand.
     * 
     * Possible values are any decimal value greater than zero or -1 which indicates the willingness to pay any
     * on-demand price. For more details on spot pricing, see [spot VMs
     * pricing](https://docs.microsoft.com/azure/virtual-machines/spot-vms#pricing)
     */
    @JsonProperty(value = "spotMaxPrice")
    private Float spotMaxPrice;

    /*
     * The tags to be persisted on the agent pool virtual machine scale set.
     */
    @JsonProperty(value = "tags")
    @JsonInclude(value = JsonInclude.Include.NON_NULL, content = JsonInclude.Include.ALWAYS)
    private Map<String, String> tags;

    /*
     * The node labels to be persisted across all nodes in agent pool.
     */
    @JsonProperty(value = "nodeLabels")
    @JsonInclude(value = JsonInclude.Include.NON_NULL, content = JsonInclude.Include.ALWAYS)
    private Map<String, String> nodeLabels;

    /*
     * The taints added to new nodes during node pool create and scale. For example, key=value:NoSchedule.
     */
    @JsonProperty(value = "nodeTaints")
    private List<String> nodeTaints;

    /*
     * The ID for Proximity Placement Group.
     */
    @JsonProperty(value = "proximityPlacementGroupID")
    private String proximityPlacementGroupId;

    /*
     * Kubelet configurations of agent nodes.
     * 
     * The Kubelet configuration on the agent pool nodes.
     */
    @JsonProperty(value = "kubeletConfig")
    private KubeletConfig kubeletConfig;

    /*
     * OS configurations of Linux agent nodes.
     * 
     * The OS configuration of Linux agent nodes.
     */
    @JsonProperty(value = "linuxOSConfig")
    private LinuxOSConfig linuxOSConfig;

    /*
     * Whether to enable host based OS and data drive encryption.
     * 
     * This is only supported on certain VM sizes and in certain Azure regions. For more information, see:
     * https://docs.microsoft.com/azure/aks/enable-host-encryption
     */
    @JsonProperty(value = "enableEncryptionAtHost")
    private Boolean enableEncryptionAtHost;

    /*
     * Whether to enable UltraSSD
     */
    @JsonProperty(value = "enableUltraSSD")
    private Boolean enableUltraSsd;

    /*
     * Whether to use a FIPS-enabled OS.
     * 
     * See [Add a FIPS-enabled node
     * pool](https://docs.microsoft.com/azure/aks/use-multiple-node-pools#add-a-fips-enabled-node-pool-preview) for
     * more details.
     */
    @JsonProperty(value = "enableFIPS")
    private Boolean enableFips;

    /*
     * GPUInstanceProfile to be used to specify GPU MIG instance profile for supported GPU VM SKU.
     */
    @JsonProperty(value = "gpuInstanceProfile")
    private GpuInstanceProfile gpuInstanceProfile;

    /*
     * CreationData to be used to specify the source Snapshot ID if the node pool will be created/upgraded using a
     * snapshot.
     */
    @JsonProperty(value = "creationData")
    private CreationData creationData;

    /*
     * The fully qualified resource ID of the Capacity Reservation Group to provide virtual machines from a reserved
     * group of Virtual Machines.
     * 
     * AKS will associate the specified agent pool with the Capacity Reservation Group.
     */
    @JsonProperty(value = "capacityReservationGroupID")
    private String capacityReservationGroupId;

    /*
     * The fully qualified resource ID of the Dedicated Host Group to provision virtual machines from, used only in
     * creation scenario and not allowed to changed once set.
     * 
     * This is of the form:
     * /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/hostGroups/{
     * hostGroupName}.
     * For more information see [Azure dedicated
     * hosts](https://docs.microsoft.com/azure/virtual-machines/dedicated-hosts).
     */
    @JsonProperty(value = "hostGroupID")
    private String hostGroupId;

    /*
     * Network-related settings of an agent pool.
     */
    @JsonProperty(value = "networkProfile")
    private AgentPoolNetworkProfile networkProfile;

    /*
     * The Windows agent pool's specific profile.
     */
    @JsonProperty(value = "windowsProfile")
    private AgentPoolWindowsProfile windowsProfile;

    /**
     * Creates an instance of ManagedClusterAgentPoolProfileProperties class.
     */
    public ManagedClusterAgentPoolProfileProperties() {
    }

    /**
     * Get the count property: Number of agents (VMs) to host docker containers. Allowed values must be in the range of
     * 0 to 1000 (inclusive) for user pools and in the range of 1 to 1000 (inclusive) for system pools. The default
     * value is 1.
     * 
     * @return the count value.
     */
    public Integer count() {
        return this.count;
    }

    /**
     * Set the count property: Number of agents (VMs) to host docker containers. Allowed values must be in the range of
     * 0 to 1000 (inclusive) for user pools and in the range of 1 to 1000 (inclusive) for system pools. The default
     * value is 1.
     * 
     * @param count the count value to set.
     * @return the ManagedClusterAgentPoolProfileProperties object itself.
     */
    public ManagedClusterAgentPoolProfileProperties withCount(Integer count) {
        this.count = count;
        return this;
    }

    /**
     * Get the vmSize property: The size of the agent pool VMs.
     * 
     * VM size availability varies by region. If a node contains insufficient compute resources (memory, cpu, etc) pods
     * might fail to run correctly. For more details on restricted VM sizes, see:
     * https://docs.microsoft.com/azure/aks/quotas-skus-regions.
     * 
     * @return the vmSize value.
     */
    public String vmSize() {
        return this.vmSize;
    }

    /**
     * Set the vmSize property: The size of the agent pool VMs.
     * 
     * VM size availability varies by region. If a node contains insufficient compute resources (memory, cpu, etc) pods
     * might fail to run correctly. For more details on restricted VM sizes, see:
     * https://docs.microsoft.com/azure/aks/quotas-skus-regions.
     * 
     * @param vmSize the vmSize value to set.
     * @return the ManagedClusterAgentPoolProfileProperties object itself.
     */
    public ManagedClusterAgentPoolProfileProperties withVmSize(String vmSize) {
        this.vmSize = vmSize;
        return this;
    }

    /**
     * Get the osDiskSizeGB property: OS Disk Size in GB to be used to specify the disk size for every machine in the
     * master/agent pool. If you specify 0, it will apply the default osDisk size according to the vmSize specified.
     * 
     * @return the osDiskSizeGB value.
     */
    public Integer osDiskSizeGB() {
        return this.osDiskSizeGB;
    }

    /**
     * Set the osDiskSizeGB property: OS Disk Size in GB to be used to specify the disk size for every machine in the
     * master/agent pool. If you specify 0, it will apply the default osDisk size according to the vmSize specified.
     * 
     * @param osDiskSizeGB the osDiskSizeGB value to set.
     * @return the ManagedClusterAgentPoolProfileProperties object itself.
     */
    public ManagedClusterAgentPoolProfileProperties withOsDiskSizeGB(Integer osDiskSizeGB) {
        this.osDiskSizeGB = osDiskSizeGB;
        return this;
    }

    /**
     * Get the osDiskType property: The OS disk type to be used for machines in the agent pool.
     * 
     * The default is 'Ephemeral' if the VM supports it and has a cache disk larger than the requested OSDiskSizeGB.
     * Otherwise, defaults to 'Managed'. May not be changed after creation. For more information see [Ephemeral
     * OS](https://docs.microsoft.com/azure/aks/cluster-configuration#ephemeral-os).
     * 
     * @return the osDiskType value.
     */
    public OSDiskType osDiskType() {
        return this.osDiskType;
    }

    /**
     * Set the osDiskType property: The OS disk type to be used for machines in the agent pool.
     * 
     * The default is 'Ephemeral' if the VM supports it and has a cache disk larger than the requested OSDiskSizeGB.
     * Otherwise, defaults to 'Managed'. May not be changed after creation. For more information see [Ephemeral
     * OS](https://docs.microsoft.com/azure/aks/cluster-configuration#ephemeral-os).
     * 
     * @param osDiskType the osDiskType value to set.
     * @return the ManagedClusterAgentPoolProfileProperties object itself.
     */
    public ManagedClusterAgentPoolProfileProperties withOsDiskType(OSDiskType osDiskType) {
        this.osDiskType = osDiskType;
        return this;
    }

    /**
     * Get the kubeletDiskType property: Determines the placement of emptyDir volumes, container runtime data root, and
     * Kubelet ephemeral storage.
     * 
     * @return the kubeletDiskType value.
     */
    public KubeletDiskType kubeletDiskType() {
        return this.kubeletDiskType;
    }

    /**
     * Set the kubeletDiskType property: Determines the placement of emptyDir volumes, container runtime data root, and
     * Kubelet ephemeral storage.
     * 
     * @param kubeletDiskType the kubeletDiskType value to set.
     * @return the ManagedClusterAgentPoolProfileProperties object itself.
     */
    public ManagedClusterAgentPoolProfileProperties withKubeletDiskType(KubeletDiskType kubeletDiskType) {
        this.kubeletDiskType = kubeletDiskType;
        return this;
    }

    /**
     * Get the workloadRuntime property: Determines the type of workload a node can run.
     * 
     * @return the workloadRuntime value.
     */
    public WorkloadRuntime workloadRuntime() {
        return this.workloadRuntime;
    }

    /**
     * Set the workloadRuntime property: Determines the type of workload a node can run.
     * 
     * @param workloadRuntime the workloadRuntime value to set.
     * @return the ManagedClusterAgentPoolProfileProperties object itself.
     */
    public ManagedClusterAgentPoolProfileProperties withWorkloadRuntime(WorkloadRuntime workloadRuntime) {
        this.workloadRuntime = workloadRuntime;
        return this;
    }

    /**
     * Get the vnetSubnetId property: The ID of the subnet which agent pool nodes and optionally pods will join on
     * startup.
     * 
     * If this is not specified, a VNET and subnet will be generated and used. If no podSubnetID is specified, this
     * applies to nodes and pods, otherwise it applies to just nodes. This is of the form:
     * /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworks/{virtualNetworkName}/subnets/{subnetName}.
     * 
     * @return the vnetSubnetId value.
     */
    public String vnetSubnetId() {
        return this.vnetSubnetId;
    }

    /**
     * Set the vnetSubnetId property: The ID of the subnet which agent pool nodes and optionally pods will join on
     * startup.
     * 
     * If this is not specified, a VNET and subnet will be generated and used. If no podSubnetID is specified, this
     * applies to nodes and pods, otherwise it applies to just nodes. This is of the form:
     * /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworks/{virtualNetworkName}/subnets/{subnetName}.
     * 
     * @param vnetSubnetId the vnetSubnetId value to set.
     * @return the ManagedClusterAgentPoolProfileProperties object itself.
     */
    public ManagedClusterAgentPoolProfileProperties withVnetSubnetId(String vnetSubnetId) {
        this.vnetSubnetId = vnetSubnetId;
        return this;
    }

    /**
     * Get the podSubnetId property: The ID of the subnet which pods will join when launched.
     * 
     * If omitted, pod IPs are statically assigned on the node subnet (see vnetSubnetID for more details). This is of
     * the form:
     * /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworks/{virtualNetworkName}/subnets/{subnetName}.
     * 
     * @return the podSubnetId value.
     */
    public String podSubnetId() {
        return this.podSubnetId;
    }

    /**
     * Set the podSubnetId property: The ID of the subnet which pods will join when launched.
     * 
     * If omitted, pod IPs are statically assigned on the node subnet (see vnetSubnetID for more details). This is of
     * the form:
     * /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworks/{virtualNetworkName}/subnets/{subnetName}.
     * 
     * @param podSubnetId the podSubnetId value to set.
     * @return the ManagedClusterAgentPoolProfileProperties object itself.
     */
    public ManagedClusterAgentPoolProfileProperties withPodSubnetId(String podSubnetId) {
        this.podSubnetId = podSubnetId;
        return this;
    }

    /**
     * Get the maxPods property: The maximum number of pods that can run on a node.
     * 
     * @return the maxPods value.
     */
    public Integer maxPods() {
        return this.maxPods;
    }

    /**
     * Set the maxPods property: The maximum number of pods that can run on a node.
     * 
     * @param maxPods the maxPods value to set.
     * @return the ManagedClusterAgentPoolProfileProperties object itself.
     */
    public ManagedClusterAgentPoolProfileProperties withMaxPods(Integer maxPods) {
        this.maxPods = maxPods;
        return this;
    }

    /**
     * Get the osType property: OsType to be used to specify os type. Choose from Linux and Windows. Default to Linux.
     * 
     * @return the osType value.
     */
    public OSType osType() {
        return this.osType;
    }

    /**
     * Set the osType property: OsType to be used to specify os type. Choose from Linux and Windows. Default to Linux.
     * 
     * @param osType the osType value to set.
     * @return the ManagedClusterAgentPoolProfileProperties object itself.
     */
    public ManagedClusterAgentPoolProfileProperties withOsType(OSType osType) {
        this.osType = osType;
        return this;
    }

    /**
     * Get the osSku property: Specifies the OS SKU used by the agent pool. The default is Ubuntu if OSType is Linux.
     * The default is Windows2019 when Kubernetes &lt;= 1.24 or Windows2022 when Kubernetes &gt;= 1.25 if OSType is
     * Windows.
     * 
     * @return the osSku value.
     */
    public OSSku osSku() {
        return this.osSku;
    }

    /**
     * Set the osSku property: Specifies the OS SKU used by the agent pool. The default is Ubuntu if OSType is Linux.
     * The default is Windows2019 when Kubernetes &lt;= 1.24 or Windows2022 when Kubernetes &gt;= 1.25 if OSType is
     * Windows.
     * 
     * @param osSku the osSku value to set.
     * @return the ManagedClusterAgentPoolProfileProperties object itself.
     */
    public ManagedClusterAgentPoolProfileProperties withOsSku(OSSku osSku) {
        this.osSku = osSku;
        return this;
    }

    /**
     * Get the maxCount property: The maximum number of nodes for auto-scaling.
     * 
     * @return the maxCount value.
     */
    public Integer maxCount() {
        return this.maxCount;
    }

    /**
     * Set the maxCount property: The maximum number of nodes for auto-scaling.
     * 
     * @param maxCount the maxCount value to set.
     * @return the ManagedClusterAgentPoolProfileProperties object itself.
     */
    public ManagedClusterAgentPoolProfileProperties withMaxCount(Integer maxCount) {
        this.maxCount = maxCount;
        return this;
    }

    /**
     * Get the minCount property: The minimum number of nodes for auto-scaling.
     * 
     * @return the minCount value.
     */
    public Integer minCount() {
        return this.minCount;
    }

    /**
     * Set the minCount property: The minimum number of nodes for auto-scaling.
     * 
     * @param minCount the minCount value to set.
     * @return the ManagedClusterAgentPoolProfileProperties object itself.
     */
    public ManagedClusterAgentPoolProfileProperties withMinCount(Integer minCount) {
        this.minCount = minCount;
        return this;
    }

    /**
     * Get the enableAutoScaling property: Whether to enable auto-scaler.
     * 
     * @return the enableAutoScaling value.
     */
    public Boolean enableAutoScaling() {
        return this.enableAutoScaling;
    }

    /**
     * Set the enableAutoScaling property: Whether to enable auto-scaler.
     * 
     * @param enableAutoScaling the enableAutoScaling value to set.
     * @return the ManagedClusterAgentPoolProfileProperties object itself.
     */
    public ManagedClusterAgentPoolProfileProperties withEnableAutoScaling(Boolean enableAutoScaling) {
        this.enableAutoScaling = enableAutoScaling;
        return this;
    }

    /**
     * Get the scaleDownMode property: This also effects the cluster autoscaler behavior. If not specified, it defaults
     * to Delete.
     * 
     * @return the scaleDownMode value.
     */
    public ScaleDownMode scaleDownMode() {
        return this.scaleDownMode;
    }

    /**
     * Set the scaleDownMode property: This also effects the cluster autoscaler behavior. If not specified, it defaults
     * to Delete.
     * 
     * @param scaleDownMode the scaleDownMode value to set.
     * @return the ManagedClusterAgentPoolProfileProperties object itself.
     */
    public ManagedClusterAgentPoolProfileProperties withScaleDownMode(ScaleDownMode scaleDownMode) {
        this.scaleDownMode = scaleDownMode;
        return this;
    }

    /**
     * Get the type property: The type of Agent Pool.
     * 
     * @return the type value.
     */
    public AgentPoolType type() {
        return this.type;
    }

    /**
     * Set the type property: The type of Agent Pool.
     * 
     * @param type the type value to set.
     * @return the ManagedClusterAgentPoolProfileProperties object itself.
     */
    public ManagedClusterAgentPoolProfileProperties withType(AgentPoolType type) {
        this.type = type;
        return this;
    }

    /**
     * Get the mode property: The mode of an agent pool.
     * 
     * A cluster must have at least one 'System' Agent Pool at all times. For additional information on agent pool
     * restrictions and best practices, see: https://docs.microsoft.com/azure/aks/use-system-pools.
     * 
     * @return the mode value.
     */
    public AgentPoolMode mode() {
        return this.mode;
    }

    /**
     * Set the mode property: The mode of an agent pool.
     * 
     * A cluster must have at least one 'System' Agent Pool at all times. For additional information on agent pool
     * restrictions and best practices, see: https://docs.microsoft.com/azure/aks/use-system-pools.
     * 
     * @param mode the mode value to set.
     * @return the ManagedClusterAgentPoolProfileProperties object itself.
     */
    public ManagedClusterAgentPoolProfileProperties withMode(AgentPoolMode mode) {
        this.mode = mode;
        return this;
    }

    /**
     * Get the orchestratorVersion property: The version of Kubernetes specified by the user.
     * 
     * Both patch version &lt;major.minor.patch&gt; (e.g. 1.20.13) and &lt;major.minor&gt; (e.g. 1.20) are supported.
     * When &lt;major.minor&gt; is specified, the latest supported GA patch version is chosen automatically. Updating
     * the cluster with the same &lt;major.minor&gt; once it has been created (e.g. 1.14.x -&gt; 1.14) will not trigger
     * an upgrade, even if a newer patch version is available. As a best practice, you should upgrade all node pools in
     * an AKS cluster to the same Kubernetes version. The node pool version must have the same major version as the
     * control plane. The node pool minor version must be within two minor versions of the control plane version. The
     * node pool version cannot be greater than the control plane version. For more information see [upgrading a node
     * pool](https://docs.microsoft.com/azure/aks/use-multiple-node-pools#upgrade-a-node-pool).
     * 
     * @return the orchestratorVersion value.
     */
    public String orchestratorVersion() {
        return this.orchestratorVersion;
    }

    /**
     * Set the orchestratorVersion property: The version of Kubernetes specified by the user.
     * 
     * Both patch version &lt;major.minor.patch&gt; (e.g. 1.20.13) and &lt;major.minor&gt; (e.g. 1.20) are supported.
     * When &lt;major.minor&gt; is specified, the latest supported GA patch version is chosen automatically. Updating
     * the cluster with the same &lt;major.minor&gt; once it has been created (e.g. 1.14.x -&gt; 1.14) will not trigger
     * an upgrade, even if a newer patch version is available. As a best practice, you should upgrade all node pools in
     * an AKS cluster to the same Kubernetes version. The node pool version must have the same major version as the
     * control plane. The node pool minor version must be within two minor versions of the control plane version. The
     * node pool version cannot be greater than the control plane version. For more information see [upgrading a node
     * pool](https://docs.microsoft.com/azure/aks/use-multiple-node-pools#upgrade-a-node-pool).
     * 
     * @param orchestratorVersion the orchestratorVersion value to set.
     * @return the ManagedClusterAgentPoolProfileProperties object itself.
     */
    public ManagedClusterAgentPoolProfileProperties withOrchestratorVersion(String orchestratorVersion) {
        this.orchestratorVersion = orchestratorVersion;
        return this;
    }

    /**
     * Get the currentOrchestratorVersion property: The version of Kubernetes the Agent Pool is running.
     * 
     * If orchestratorVersion is a fully specified version &lt;major.minor.patch&gt;, this field will be exactly equal
     * to it. If orchestratorVersion is &lt;major.minor&gt;, this field will contain the full &lt;major.minor.patch&gt;
     * version being used.
     * 
     * @return the currentOrchestratorVersion value.
     */
    public String currentOrchestratorVersion() {
        return this.currentOrchestratorVersion;
    }

    /**
     * Get the nodeImageVersion property: The version of node image.
     * 
     * @return the nodeImageVersion value.
     */
    public String nodeImageVersion() {
        return this.nodeImageVersion;
    }

    /**
     * Get the upgradeSettings property: Settings for upgrading the agentpool.
     * 
     * @return the upgradeSettings value.
     */
    public AgentPoolUpgradeSettings upgradeSettings() {
        return this.upgradeSettings;
    }

    /**
     * Set the upgradeSettings property: Settings for upgrading the agentpool.
     * 
     * @param upgradeSettings the upgradeSettings value to set.
     * @return the ManagedClusterAgentPoolProfileProperties object itself.
     */
    public ManagedClusterAgentPoolProfileProperties withUpgradeSettings(AgentPoolUpgradeSettings upgradeSettings) {
        this.upgradeSettings = upgradeSettings;
        return this;
    }

    /**
     * Get the provisioningState property: The current deployment or provisioning state.
     * 
     * @return the provisioningState value.
     */
    public String provisioningState() {
        return this.provisioningState;
    }

    /**
     * Get the powerState property: When an Agent Pool is first created it is initially Running. The Agent Pool can be
     * stopped by setting this field to Stopped. A stopped Agent Pool stops all of its VMs and does not accrue billing
     * charges. An Agent Pool can only be stopped if it is Running and provisioning state is Succeeded.
     * 
     * @return the powerState value.
     */
    public PowerState powerState() {
        return this.powerState;
    }

    /**
     * Set the powerState property: When an Agent Pool is first created it is initially Running. The Agent Pool can be
     * stopped by setting this field to Stopped. A stopped Agent Pool stops all of its VMs and does not accrue billing
     * charges. An Agent Pool can only be stopped if it is Running and provisioning state is Succeeded.
     * 
     * @param powerState the powerState value to set.
     * @return the ManagedClusterAgentPoolProfileProperties object itself.
     */
    public ManagedClusterAgentPoolProfileProperties withPowerState(PowerState powerState) {
        this.powerState = powerState;
        return this;
    }

    /**
     * Get the availabilityZones property: The list of Availability zones to use for nodes. This can only be specified
     * if the AgentPoolType property is 'VirtualMachineScaleSets'.
     * 
     * @return the availabilityZones value.
     */
    public List<String> availabilityZones() {
        return this.availabilityZones;
    }

    /**
     * Set the availabilityZones property: The list of Availability zones to use for nodes. This can only be specified
     * if the AgentPoolType property is 'VirtualMachineScaleSets'.
     * 
     * @param availabilityZones the availabilityZones value to set.
     * @return the ManagedClusterAgentPoolProfileProperties object itself.
     */
    public ManagedClusterAgentPoolProfileProperties withAvailabilityZones(List<String> availabilityZones) {
        this.availabilityZones = availabilityZones;
        return this;
    }

    /**
     * Get the enableNodePublicIp property: Whether each node is allocated its own public IP.
     * 
     * Some scenarios may require nodes in a node pool to receive their own dedicated public IP addresses. A common
     * scenario is for gaming workloads, where a console needs to make a direct connection to a cloud virtual machine
     * to minimize hops. For more information see [assigning a public IP per
     * node](https://docs.microsoft.com/azure/aks/use-multiple-node-pools#assign-a-public-ip-per-node-for-your-node-pools).
     * The default is false.
     * 
     * @return the enableNodePublicIp value.
     */
    public Boolean enableNodePublicIp() {
        return this.enableNodePublicIp;
    }

    /**
     * Set the enableNodePublicIp property: Whether each node is allocated its own public IP.
     * 
     * Some scenarios may require nodes in a node pool to receive their own dedicated public IP addresses. A common
     * scenario is for gaming workloads, where a console needs to make a direct connection to a cloud virtual machine
     * to minimize hops. For more information see [assigning a public IP per
     * node](https://docs.microsoft.com/azure/aks/use-multiple-node-pools#assign-a-public-ip-per-node-for-your-node-pools).
     * The default is false.
     * 
     * @param enableNodePublicIp the enableNodePublicIp value to set.
     * @return the ManagedClusterAgentPoolProfileProperties object itself.
     */
    public ManagedClusterAgentPoolProfileProperties withEnableNodePublicIp(Boolean enableNodePublicIp) {
        this.enableNodePublicIp = enableNodePublicIp;
        return this;
    }

    /**
     * Get the nodePublicIpPrefixId property: The public IP prefix ID which VM nodes should use IPs from.
     * 
     * This is of the form:
     * /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/publicIPPrefixes/{publicIPPrefixName}.
     * 
     * @return the nodePublicIpPrefixId value.
     */
    public String nodePublicIpPrefixId() {
        return this.nodePublicIpPrefixId;
    }

    /**
     * Set the nodePublicIpPrefixId property: The public IP prefix ID which VM nodes should use IPs from.
     * 
     * This is of the form:
     * /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/publicIPPrefixes/{publicIPPrefixName}.
     * 
     * @param nodePublicIpPrefixId the nodePublicIpPrefixId value to set.
     * @return the ManagedClusterAgentPoolProfileProperties object itself.
     */
    public ManagedClusterAgentPoolProfileProperties withNodePublicIpPrefixId(String nodePublicIpPrefixId) {
        this.nodePublicIpPrefixId = nodePublicIpPrefixId;
        return this;
    }

    /**
     * Get the scaleSetPriority property: The Virtual Machine Scale Set priority. If not specified, the default is
     * 'Regular'.
     * 
     * @return the scaleSetPriority value.
     */
    public ScaleSetPriority scaleSetPriority() {
        return this.scaleSetPriority;
    }

    /**
     * Set the scaleSetPriority property: The Virtual Machine Scale Set priority. If not specified, the default is
     * 'Regular'.
     * 
     * @param scaleSetPriority the scaleSetPriority value to set.
     * @return the ManagedClusterAgentPoolProfileProperties object itself.
     */
    public ManagedClusterAgentPoolProfileProperties withScaleSetPriority(ScaleSetPriority scaleSetPriority) {
        this.scaleSetPriority = scaleSetPriority;
        return this;
    }

    /**
     * Get the scaleSetEvictionPolicy property: The Virtual Machine Scale Set eviction policy.
     * 
     * This cannot be specified unless the scaleSetPriority is 'Spot'. If not specified, the default is 'Delete'.
     * 
     * @return the scaleSetEvictionPolicy value.
     */
    public ScaleSetEvictionPolicy scaleSetEvictionPolicy() {
        return this.scaleSetEvictionPolicy;
    }

    /**
     * Set the scaleSetEvictionPolicy property: The Virtual Machine Scale Set eviction policy.
     * 
     * This cannot be specified unless the scaleSetPriority is 'Spot'. If not specified, the default is 'Delete'.
     * 
     * @param scaleSetEvictionPolicy the scaleSetEvictionPolicy value to set.
     * @return the ManagedClusterAgentPoolProfileProperties object itself.
     */
    public ManagedClusterAgentPoolProfileProperties
        withScaleSetEvictionPolicy(ScaleSetEvictionPolicy scaleSetEvictionPolicy) {
        this.scaleSetEvictionPolicy = scaleSetEvictionPolicy;
        return this;
    }

    /**
     * Get the spotMaxPrice property: The max price (in US Dollars) you are willing to pay for spot instances. Possible
     * values are any decimal value greater than zero or -1 which indicates default price to be up-to on-demand.
     * 
     * Possible values are any decimal value greater than zero or -1 which indicates the willingness to pay any
     * on-demand price. For more details on spot pricing, see [spot VMs
     * pricing](https://docs.microsoft.com/azure/virtual-machines/spot-vms#pricing).
     * 
     * @return the spotMaxPrice value.
     */
    public Float spotMaxPrice() {
        return this.spotMaxPrice;
    }

    /**
     * Set the spotMaxPrice property: The max price (in US Dollars) you are willing to pay for spot instances. Possible
     * values are any decimal value greater than zero or -1 which indicates default price to be up-to on-demand.
     * 
     * Possible values are any decimal value greater than zero or -1 which indicates the willingness to pay any
     * on-demand price. For more details on spot pricing, see [spot VMs
     * pricing](https://docs.microsoft.com/azure/virtual-machines/spot-vms#pricing).
     * 
     * @param spotMaxPrice the spotMaxPrice value to set.
     * @return the ManagedClusterAgentPoolProfileProperties object itself.
     */
    public ManagedClusterAgentPoolProfileProperties withSpotMaxPrice(Float spotMaxPrice) {
        this.spotMaxPrice = spotMaxPrice;
        return this;
    }

    /**
     * Get the tags property: The tags to be persisted on the agent pool virtual machine scale set.
     * 
     * @return the tags value.
     */
    public Map<String, String> tags() {
        return this.tags;
    }

    /**
     * Set the tags property: The tags to be persisted on the agent pool virtual machine scale set.
     * 
     * @param tags the tags value to set.
     * @return the ManagedClusterAgentPoolProfileProperties object itself.
     */
    public ManagedClusterAgentPoolProfileProperties withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    /**
     * Get the nodeLabels property: The node labels to be persisted across all nodes in agent pool.
     * 
     * @return the nodeLabels value.
     */
    public Map<String, String> nodeLabels() {
        return this.nodeLabels;
    }

    /**
     * Set the nodeLabels property: The node labels to be persisted across all nodes in agent pool.
     * 
     * @param nodeLabels the nodeLabels value to set.
     * @return the ManagedClusterAgentPoolProfileProperties object itself.
     */
    public ManagedClusterAgentPoolProfileProperties withNodeLabels(Map<String, String> nodeLabels) {
        this.nodeLabels = nodeLabels;
        return this;
    }

    /**
     * Get the nodeTaints property: The taints added to new nodes during node pool create and scale. For example,
     * key=value:NoSchedule.
     * 
     * @return the nodeTaints value.
     */
    public List<String> nodeTaints() {
        return this.nodeTaints;
    }

    /**
     * Set the nodeTaints property: The taints added to new nodes during node pool create and scale. For example,
     * key=value:NoSchedule.
     * 
     * @param nodeTaints the nodeTaints value to set.
     * @return the ManagedClusterAgentPoolProfileProperties object itself.
     */
    public ManagedClusterAgentPoolProfileProperties withNodeTaints(List<String> nodeTaints) {
        this.nodeTaints = nodeTaints;
        return this;
    }

    /**
     * Get the proximityPlacementGroupId property: The ID for Proximity Placement Group.
     * 
     * @return the proximityPlacementGroupId value.
     */
    public String proximityPlacementGroupId() {
        return this.proximityPlacementGroupId;
    }

    /**
     * Set the proximityPlacementGroupId property: The ID for Proximity Placement Group.
     * 
     * @param proximityPlacementGroupId the proximityPlacementGroupId value to set.
     * @return the ManagedClusterAgentPoolProfileProperties object itself.
     */
    public ManagedClusterAgentPoolProfileProperties withProximityPlacementGroupId(String proximityPlacementGroupId) {
        this.proximityPlacementGroupId = proximityPlacementGroupId;
        return this;
    }

    /**
     * Get the kubeletConfig property: Kubelet configurations of agent nodes.
     * 
     * The Kubelet configuration on the agent pool nodes.
     * 
     * @return the kubeletConfig value.
     */
    public KubeletConfig kubeletConfig() {
        return this.kubeletConfig;
    }

    /**
     * Set the kubeletConfig property: Kubelet configurations of agent nodes.
     * 
     * The Kubelet configuration on the agent pool nodes.
     * 
     * @param kubeletConfig the kubeletConfig value to set.
     * @return the ManagedClusterAgentPoolProfileProperties object itself.
     */
    public ManagedClusterAgentPoolProfileProperties withKubeletConfig(KubeletConfig kubeletConfig) {
        this.kubeletConfig = kubeletConfig;
        return this;
    }

    /**
     * Get the linuxOSConfig property: OS configurations of Linux agent nodes.
     * 
     * The OS configuration of Linux agent nodes.
     * 
     * @return the linuxOSConfig value.
     */
    public LinuxOSConfig linuxOSConfig() {
        return this.linuxOSConfig;
    }

    /**
     * Set the linuxOSConfig property: OS configurations of Linux agent nodes.
     * 
     * The OS configuration of Linux agent nodes.
     * 
     * @param linuxOSConfig the linuxOSConfig value to set.
     * @return the ManagedClusterAgentPoolProfileProperties object itself.
     */
    public ManagedClusterAgentPoolProfileProperties withLinuxOSConfig(LinuxOSConfig linuxOSConfig) {
        this.linuxOSConfig = linuxOSConfig;
        return this;
    }

    /**
     * Get the enableEncryptionAtHost property: Whether to enable host based OS and data drive encryption.
     * 
     * This is only supported on certain VM sizes and in certain Azure regions. For more information, see:
     * https://docs.microsoft.com/azure/aks/enable-host-encryption.
     * 
     * @return the enableEncryptionAtHost value.
     */
    public Boolean enableEncryptionAtHost() {
        return this.enableEncryptionAtHost;
    }

    /**
     * Set the enableEncryptionAtHost property: Whether to enable host based OS and data drive encryption.
     * 
     * This is only supported on certain VM sizes and in certain Azure regions. For more information, see:
     * https://docs.microsoft.com/azure/aks/enable-host-encryption.
     * 
     * @param enableEncryptionAtHost the enableEncryptionAtHost value to set.
     * @return the ManagedClusterAgentPoolProfileProperties object itself.
     */
    public ManagedClusterAgentPoolProfileProperties withEnableEncryptionAtHost(Boolean enableEncryptionAtHost) {
        this.enableEncryptionAtHost = enableEncryptionAtHost;
        return this;
    }

    /**
     * Get the enableUltraSsd property: Whether to enable UltraSSD.
     * 
     * @return the enableUltraSsd value.
     */
    public Boolean enableUltraSsd() {
        return this.enableUltraSsd;
    }

    /**
     * Set the enableUltraSsd property: Whether to enable UltraSSD.
     * 
     * @param enableUltraSsd the enableUltraSsd value to set.
     * @return the ManagedClusterAgentPoolProfileProperties object itself.
     */
    public ManagedClusterAgentPoolProfileProperties withEnableUltraSsd(Boolean enableUltraSsd) {
        this.enableUltraSsd = enableUltraSsd;
        return this;
    }

    /**
     * Get the enableFips property: Whether to use a FIPS-enabled OS.
     * 
     * See [Add a FIPS-enabled node
     * pool](https://docs.microsoft.com/azure/aks/use-multiple-node-pools#add-a-fips-enabled-node-pool-preview) for
     * more details.
     * 
     * @return the enableFips value.
     */
    public Boolean enableFips() {
        return this.enableFips;
    }

    /**
     * Set the enableFips property: Whether to use a FIPS-enabled OS.
     * 
     * See [Add a FIPS-enabled node
     * pool](https://docs.microsoft.com/azure/aks/use-multiple-node-pools#add-a-fips-enabled-node-pool-preview) for
     * more details.
     * 
     * @param enableFips the enableFips value to set.
     * @return the ManagedClusterAgentPoolProfileProperties object itself.
     */
    public ManagedClusterAgentPoolProfileProperties withEnableFips(Boolean enableFips) {
        this.enableFips = enableFips;
        return this;
    }

    /**
     * Get the gpuInstanceProfile property: GPUInstanceProfile to be used to specify GPU MIG instance profile for
     * supported GPU VM SKU.
     * 
     * @return the gpuInstanceProfile value.
     */
    public GpuInstanceProfile gpuInstanceProfile() {
        return this.gpuInstanceProfile;
    }

    /**
     * Set the gpuInstanceProfile property: GPUInstanceProfile to be used to specify GPU MIG instance profile for
     * supported GPU VM SKU.
     * 
     * @param gpuInstanceProfile the gpuInstanceProfile value to set.
     * @return the ManagedClusterAgentPoolProfileProperties object itself.
     */
    public ManagedClusterAgentPoolProfileProperties withGpuInstanceProfile(GpuInstanceProfile gpuInstanceProfile) {
        this.gpuInstanceProfile = gpuInstanceProfile;
        return this;
    }

    /**
     * Get the creationData property: CreationData to be used to specify the source Snapshot ID if the node pool will
     * be created/upgraded using a snapshot.
     * 
     * @return the creationData value.
     */
    public CreationData creationData() {
        return this.creationData;
    }

    /**
     * Set the creationData property: CreationData to be used to specify the source Snapshot ID if the node pool will
     * be created/upgraded using a snapshot.
     * 
     * @param creationData the creationData value to set.
     * @return the ManagedClusterAgentPoolProfileProperties object itself.
     */
    public ManagedClusterAgentPoolProfileProperties withCreationData(CreationData creationData) {
        this.creationData = creationData;
        return this;
    }

    /**
     * Get the capacityReservationGroupId property: The fully qualified resource ID of the Capacity Reservation Group
     * to provide virtual machines from a reserved group of Virtual Machines.
     * 
     * AKS will associate the specified agent pool with the Capacity Reservation Group.
     * 
     * @return the capacityReservationGroupId value.
     */
    public String capacityReservationGroupId() {
        return this.capacityReservationGroupId;
    }

    /**
     * Set the capacityReservationGroupId property: The fully qualified resource ID of the Capacity Reservation Group
     * to provide virtual machines from a reserved group of Virtual Machines.
     * 
     * AKS will associate the specified agent pool with the Capacity Reservation Group.
     * 
     * @param capacityReservationGroupId the capacityReservationGroupId value to set.
     * @return the ManagedClusterAgentPoolProfileProperties object itself.
     */
    public ManagedClusterAgentPoolProfileProperties withCapacityReservationGroupId(String capacityReservationGroupId) {
        this.capacityReservationGroupId = capacityReservationGroupId;
        return this;
    }

    /**
     * Get the hostGroupId property: The fully qualified resource ID of the Dedicated Host Group to provision virtual
     * machines from, used only in creation scenario and not allowed to changed once set.
     * 
     * This is of the form:
     * /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/hostGroups/{hostGroupName}.
     * For more information see [Azure dedicated
     * hosts](https://docs.microsoft.com/azure/virtual-machines/dedicated-hosts).
     * 
     * @return the hostGroupId value.
     */
    public String hostGroupId() {
        return this.hostGroupId;
    }

    /**
     * Set the hostGroupId property: The fully qualified resource ID of the Dedicated Host Group to provision virtual
     * machines from, used only in creation scenario and not allowed to changed once set.
     * 
     * This is of the form:
     * /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/hostGroups/{hostGroupName}.
     * For more information see [Azure dedicated
     * hosts](https://docs.microsoft.com/azure/virtual-machines/dedicated-hosts).
     * 
     * @param hostGroupId the hostGroupId value to set.
     * @return the ManagedClusterAgentPoolProfileProperties object itself.
     */
    public ManagedClusterAgentPoolProfileProperties withHostGroupId(String hostGroupId) {
        this.hostGroupId = hostGroupId;
        return this;
    }

    /**
     * Get the networkProfile property: Network-related settings of an agent pool.
     * 
     * @return the networkProfile value.
     */
    public AgentPoolNetworkProfile networkProfile() {
        return this.networkProfile;
    }

    /**
     * Set the networkProfile property: Network-related settings of an agent pool.
     * 
     * @param networkProfile the networkProfile value to set.
     * @return the ManagedClusterAgentPoolProfileProperties object itself.
     */
    public ManagedClusterAgentPoolProfileProperties withNetworkProfile(AgentPoolNetworkProfile networkProfile) {
        this.networkProfile = networkProfile;
        return this;
    }

    /**
     * Get the windowsProfile property: The Windows agent pool's specific profile.
     * 
     * @return the windowsProfile value.
     */
    public AgentPoolWindowsProfile windowsProfile() {
        return this.windowsProfile;
    }

    /**
     * Set the windowsProfile property: The Windows agent pool's specific profile.
     * 
     * @param windowsProfile the windowsProfile value to set.
     * @return the ManagedClusterAgentPoolProfileProperties object itself.
     */
    public ManagedClusterAgentPoolProfileProperties withWindowsProfile(AgentPoolWindowsProfile windowsProfile) {
        this.windowsProfile = windowsProfile;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (upgradeSettings() != null) {
            upgradeSettings().validate();
        }
        if (powerState() != null) {
            powerState().validate();
        }
        if (kubeletConfig() != null) {
            kubeletConfig().validate();
        }
        if (linuxOSConfig() != null) {
            linuxOSConfig().validate();
        }
        if (creationData() != null) {
            creationData().validate();
        }
        if (networkProfile() != null) {
            networkProfile().validate();
        }
        if (windowsProfile() != null) {
            windowsProfile().validate();
        }
    }
}
