// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Istio ingress gateway configuration. For now, we support up to one external ingress gateway named
 * `aks-istio-ingressgateway-external` and one internal ingress gateway named `aks-istio-ingressgateway-internal`.
 */
@Fluent
public final class IstioIngressGateway {
    /*
     * Mode of an ingress gateway.
     */
    @JsonProperty(value = "mode", required = true)
    private IstioIngressGatewayMode mode;

    /*
     * Whether to enable the ingress gateway.
     */
    @JsonProperty(value = "enabled", required = true)
    private boolean enabled;

    /**
     * Creates an instance of IstioIngressGateway class.
     */
    public IstioIngressGateway() {
    }

    /**
     * Get the mode property: Mode of an ingress gateway.
     * 
     * @return the mode value.
     */
    public IstioIngressGatewayMode mode() {
        return this.mode;
    }

    /**
     * Set the mode property: Mode of an ingress gateway.
     * 
     * @param mode the mode value to set.
     * @return the IstioIngressGateway object itself.
     */
    public IstioIngressGateway withMode(IstioIngressGatewayMode mode) {
        this.mode = mode;
        return this;
    }

    /**
     * Get the enabled property: Whether to enable the ingress gateway.
     * 
     * @return the enabled value.
     */
    public boolean enabled() {
        return this.enabled;
    }

    /**
     * Set the enabled property: Whether to enable the ingress gateway.
     * 
     * @param enabled the enabled value to set.
     * @return the IstioIngressGateway object itself.
     */
    public IstioIngressGateway withEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (mode() == null) {
            throw LOGGER.logExceptionAsError(
                new IllegalArgumentException("Missing required property mode in model IstioIngressGateway"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(IstioIngressGateway.class);
}
