// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.resourcemanager.containerservice.fluent.AgentPoolsClient;
import com.azure.resourcemanager.containerservice.fluent.models.AgentPoolAvailableVersionsInner;
import com.azure.resourcemanager.containerservice.fluent.models.AgentPoolInner;
import com.azure.resourcemanager.containerservice.fluent.models.AgentPoolUpgradeProfileInner;
import com.azure.resourcemanager.containerservice.models.AgentPoolListResult;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

/**
 * An instance of this class provides access to all the operations defined in AgentPoolsClient.
 */
public final class AgentPoolsClientImpl implements AgentPoolsClient {
    /**
     * The proxy service used to perform REST calls.
     */
    private final AgentPoolsService service;

    /**
     * The service client containing this operation class.
     */
    private final ContainerServiceManagementClientImpl client;

    /**
     * Initializes an instance of AgentPoolsClientImpl.
     * 
     * @param client the instance of the service client containing this operation class.
     */
    AgentPoolsClientImpl(ContainerServiceManagementClientImpl client) {
        this.service
            = RestProxy.create(AgentPoolsService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    /**
     * The interface defining all the services for ContainerServiceManagementClientAgentPools to be used by the proxy
     * service to perform REST calls.
     */
    @Host("{$host}")
    @ServiceInterface(name = "ContainerServiceMana")
    public interface AgentPoolsService {
        @Headers({ "Content-Type: application/json" })
        @Post("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerService/managedclusters/{resourceName}/agentPools/{agentPoolName}/abort")
        @ExpectedResponses({ 202, 204 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> abortLatestOperation(@HostParam("$host") String endpoint,
            @QueryParam("api-version") String apiVersion, @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("resourceName") String resourceName,
            @PathParam("agentPoolName") String agentPoolName, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerService/managedClusters/{resourceName}/agentPools")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<AgentPoolListResult>> list(@HostParam("$host") String endpoint,
            @QueryParam("api-version") String apiVersion, @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("resourceName") String resourceName,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerService/managedClusters/{resourceName}/agentPools/{agentPoolName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<AgentPoolInner>> get(@HostParam("$host") String endpoint,
            @QueryParam("api-version") String apiVersion, @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("resourceName") String resourceName,
            @PathParam("agentPoolName") String agentPoolName, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Put("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerService/managedClusters/{resourceName}/agentPools/{agentPoolName}")
        @ExpectedResponses({ 200, 201 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> createOrUpdate(@HostParam("$host") String endpoint,
            @QueryParam("api-version") String apiVersion, @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("resourceName") String resourceName,
            @PathParam("agentPoolName") String agentPoolName, @BodyParam("application/json") AgentPoolInner parameters,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Delete("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerService/managedClusters/{resourceName}/agentPools/{agentPoolName}")
        @ExpectedResponses({ 202, 204 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> delete(@HostParam("$host") String endpoint,
            @QueryParam("api-version") String apiVersion, @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("resourceName") String resourceName,
            @PathParam("agentPoolName") String agentPoolName, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerService/managedClusters/{resourceName}/agentPools/{agentPoolName}/upgradeProfiles/default")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<AgentPoolUpgradeProfileInner>> getUpgradeProfile(@HostParam("$host") String endpoint,
            @QueryParam("api-version") String apiVersion, @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("resourceName") String resourceName,
            @PathParam("agentPoolName") String agentPoolName, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerService/managedClusters/{resourceName}/availableAgentPoolVersions")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<AgentPoolAvailableVersionsInner>> getAvailableAgentPoolVersions(
            @HostParam("$host") String endpoint, @QueryParam("api-version") String apiVersion,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("resourceName") String resourceName,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerService/managedClusters/{resourceName}/agentPools/{agentPoolName}/upgradeNodeImageVersion")
        @ExpectedResponses({ 200, 202 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> upgradeNodeImageVersion(@HostParam("$host") String endpoint,
            @QueryParam("api-version") String apiVersion, @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("resourceName") String resourceName,
            @PathParam("agentPoolName") String agentPoolName, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<AgentPoolListResult>> listNext(@PathParam(value = "nextLink", encoded = true) String nextLink,
            @HostParam("$host") String endpoint, @HeaderParam("Accept") String accept, Context context);
    }

    /**
     * Aborts last operation running on agent pool.
     * 
     * Aborts the currently running operation on the agent pool. The Agent Pool will be moved to a Canceling state and
     * eventually to a Canceled state when cancellation finishes. If the operation completes before cancellation can
     * take place, a 409 error code is returned.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the managed cluster resource.
     * @param agentPoolName The name of the agent pool.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> abortLatestOperationWithResponseAsync(String resourceGroupName,
        String resourceName, String agentPoolName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        if (agentPoolName == null) {
            return Mono.error(new IllegalArgumentException("Parameter agentPoolName is required and cannot be null."));
        }
        final String apiVersion = "2024-01-01";
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.abortLatestOperation(this.client.getEndpoint(), apiVersion,
                this.client.getSubscriptionId(), resourceGroupName, resourceName, agentPoolName, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Aborts last operation running on agent pool.
     * 
     * Aborts the currently running operation on the agent pool. The Agent Pool will be moved to a Canceling state and
     * eventually to a Canceled state when cancellation finishes. If the operation completes before cancellation can
     * take place, a 409 error code is returned.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the managed cluster resource.
     * @param agentPoolName The name of the agent pool.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> abortLatestOperationWithResponseAsync(String resourceGroupName,
        String resourceName, String agentPoolName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        if (agentPoolName == null) {
            return Mono.error(new IllegalArgumentException("Parameter agentPoolName is required and cannot be null."));
        }
        final String apiVersion = "2024-01-01";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.abortLatestOperation(this.client.getEndpoint(), apiVersion, this.client.getSubscriptionId(),
            resourceGroupName, resourceName, agentPoolName, accept, context);
    }

    /**
     * Aborts last operation running on agent pool.
     * 
     * Aborts the currently running operation on the agent pool. The Agent Pool will be moved to a Canceling state and
     * eventually to a Canceled state when cancellation finishes. If the operation completes before cancellation can
     * take place, a 409 error code is returned.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the managed cluster resource.
     * @param agentPoolName The name of the agent pool.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Void>, Void> beginAbortLatestOperationAsync(String resourceGroupName,
        String resourceName, String agentPoolName) {
        Mono<Response<Flux<ByteBuffer>>> mono
            = abortLatestOperationWithResponseAsync(resourceGroupName, resourceName, agentPoolName);
        return this.client.<Void, Void>getLroResult(mono, this.client.getHttpPipeline(), Void.class, Void.class,
            this.client.getContext());
    }

    /**
     * Aborts last operation running on agent pool.
     * 
     * Aborts the currently running operation on the agent pool. The Agent Pool will be moved to a Canceling state and
     * eventually to a Canceled state when cancellation finishes. If the operation completes before cancellation can
     * take place, a 409 error code is returned.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the managed cluster resource.
     * @param agentPoolName The name of the agent pool.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginAbortLatestOperationAsync(String resourceGroupName,
        String resourceName, String agentPoolName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono
            = abortLatestOperationWithResponseAsync(resourceGroupName, resourceName, agentPoolName, context);
        return this.client.<Void, Void>getLroResult(mono, this.client.getHttpPipeline(), Void.class, Void.class,
            context);
    }

    /**
     * Aborts last operation running on agent pool.
     * 
     * Aborts the currently running operation on the agent pool. The Agent Pool will be moved to a Canceling state and
     * eventually to a Canceled state when cancellation finishes. If the operation completes before cancellation can
     * take place, a 409 error code is returned.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the managed cluster resource.
     * @param agentPoolName The name of the agent pool.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginAbortLatestOperation(String resourceGroupName, String resourceName,
        String agentPoolName) {
        return this.beginAbortLatestOperationAsync(resourceGroupName, resourceName, agentPoolName).getSyncPoller();
    }

    /**
     * Aborts last operation running on agent pool.
     * 
     * Aborts the currently running operation on the agent pool. The Agent Pool will be moved to a Canceling state and
     * eventually to a Canceled state when cancellation finishes. If the operation completes before cancellation can
     * take place, a 409 error code is returned.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the managed cluster resource.
     * @param agentPoolName The name of the agent pool.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginAbortLatestOperation(String resourceGroupName, String resourceName,
        String agentPoolName, Context context) {
        return this.beginAbortLatestOperationAsync(resourceGroupName, resourceName, agentPoolName, context)
            .getSyncPoller();
    }

    /**
     * Aborts last operation running on agent pool.
     * 
     * Aborts the currently running operation on the agent pool. The Agent Pool will be moved to a Canceling state and
     * eventually to a Canceled state when cancellation finishes. If the operation completes before cancellation can
     * take place, a 409 error code is returned.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the managed cluster resource.
     * @param agentPoolName The name of the agent pool.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> abortLatestOperationAsync(String resourceGroupName, String resourceName, String agentPoolName) {
        return beginAbortLatestOperationAsync(resourceGroupName, resourceName, agentPoolName).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Aborts last operation running on agent pool.
     * 
     * Aborts the currently running operation on the agent pool. The Agent Pool will be moved to a Canceling state and
     * eventually to a Canceled state when cancellation finishes. If the operation completes before cancellation can
     * take place, a 409 error code is returned.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the managed cluster resource.
     * @param agentPoolName The name of the agent pool.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Void> abortLatestOperationAsync(String resourceGroupName, String resourceName, String agentPoolName,
        Context context) {
        return beginAbortLatestOperationAsync(resourceGroupName, resourceName, agentPoolName, context).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Aborts last operation running on agent pool.
     * 
     * Aborts the currently running operation on the agent pool. The Agent Pool will be moved to a Canceling state and
     * eventually to a Canceled state when cancellation finishes. If the operation completes before cancellation can
     * take place, a 409 error code is returned.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the managed cluster resource.
     * @param agentPoolName The name of the agent pool.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void abortLatestOperation(String resourceGroupName, String resourceName, String agentPoolName) {
        abortLatestOperationAsync(resourceGroupName, resourceName, agentPoolName).block();
    }

    /**
     * Aborts last operation running on agent pool.
     * 
     * Aborts the currently running operation on the agent pool. The Agent Pool will be moved to a Canceling state and
     * eventually to a Canceled state when cancellation finishes. If the operation completes before cancellation can
     * take place, a 409 error code is returned.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the managed cluster resource.
     * @param agentPoolName The name of the agent pool.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void abortLatestOperation(String resourceGroupName, String resourceName, String agentPoolName,
        Context context) {
        abortLatestOperationAsync(resourceGroupName, resourceName, agentPoolName, context).block();
    }

    /**
     * Gets a list of agent pools in the specified managed cluster.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the managed cluster resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of agent pools in the specified managed cluster along with {@link PagedResponse} on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<AgentPoolInner>> listSinglePageAsync(String resourceGroupName, String resourceName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        final String apiVersion = "2024-01-01";
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.list(this.client.getEndpoint(), apiVersion, this.client.getSubscriptionId(),
                resourceGroupName, resourceName, accept, context))
            .<PagedResponse<AgentPoolInner>>map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(),
                res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Gets a list of agent pools in the specified managed cluster.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the managed cluster resource.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of agent pools in the specified managed cluster along with {@link PagedResponse} on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<AgentPoolInner>> listSinglePageAsync(String resourceGroupName, String resourceName,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        final String apiVersion = "2024-01-01";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .list(this.client.getEndpoint(), apiVersion, this.client.getSubscriptionId(), resourceGroupName,
                resourceName, accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * Gets a list of agent pools in the specified managed cluster.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the managed cluster resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of agent pools in the specified managed cluster as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<AgentPoolInner> listAsync(String resourceGroupName, String resourceName) {
        return new PagedFlux<>(() -> listSinglePageAsync(resourceGroupName, resourceName),
            nextLink -> listNextSinglePageAsync(nextLink));
    }

    /**
     * Gets a list of agent pools in the specified managed cluster.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the managed cluster resource.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of agent pools in the specified managed cluster as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<AgentPoolInner> listAsync(String resourceGroupName, String resourceName, Context context) {
        return new PagedFlux<>(() -> listSinglePageAsync(resourceGroupName, resourceName, context),
            nextLink -> listNextSinglePageAsync(nextLink, context));
    }

    /**
     * Gets a list of agent pools in the specified managed cluster.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the managed cluster resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of agent pools in the specified managed cluster as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<AgentPoolInner> list(String resourceGroupName, String resourceName) {
        return new PagedIterable<>(listAsync(resourceGroupName, resourceName));
    }

    /**
     * Gets a list of agent pools in the specified managed cluster.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the managed cluster resource.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of agent pools in the specified managed cluster as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<AgentPoolInner> list(String resourceGroupName, String resourceName, Context context) {
        return new PagedIterable<>(listAsync(resourceGroupName, resourceName, context));
    }

    /**
     * Gets the specified managed cluster agent pool.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the managed cluster resource.
     * @param agentPoolName The name of the agent pool.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the specified managed cluster agent pool along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<AgentPoolInner>> getWithResponseAsync(String resourceGroupName, String resourceName,
        String agentPoolName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        if (agentPoolName == null) {
            return Mono.error(new IllegalArgumentException("Parameter agentPoolName is required and cannot be null."));
        }
        final String apiVersion = "2024-01-01";
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.get(this.client.getEndpoint(), apiVersion, this.client.getSubscriptionId(),
                resourceGroupName, resourceName, agentPoolName, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Gets the specified managed cluster agent pool.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the managed cluster resource.
     * @param agentPoolName The name of the agent pool.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the specified managed cluster agent pool along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<AgentPoolInner>> getWithResponseAsync(String resourceGroupName, String resourceName,
        String agentPoolName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        if (agentPoolName == null) {
            return Mono.error(new IllegalArgumentException("Parameter agentPoolName is required and cannot be null."));
        }
        final String apiVersion = "2024-01-01";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.get(this.client.getEndpoint(), apiVersion, this.client.getSubscriptionId(), resourceGroupName,
            resourceName, agentPoolName, accept, context);
    }

    /**
     * Gets the specified managed cluster agent pool.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the managed cluster resource.
     * @param agentPoolName The name of the agent pool.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the specified managed cluster agent pool on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<AgentPoolInner> getAsync(String resourceGroupName, String resourceName, String agentPoolName) {
        return getWithResponseAsync(resourceGroupName, resourceName, agentPoolName)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Gets the specified managed cluster agent pool.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the managed cluster resource.
     * @param agentPoolName The name of the agent pool.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the specified managed cluster agent pool along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<AgentPoolInner> getWithResponse(String resourceGroupName, String resourceName, String agentPoolName,
        Context context) {
        return getWithResponseAsync(resourceGroupName, resourceName, agentPoolName, context).block();
    }

    /**
     * Gets the specified managed cluster agent pool.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the managed cluster resource.
     * @param agentPoolName The name of the agent pool.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the specified managed cluster agent pool.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public AgentPoolInner get(String resourceGroupName, String resourceName, String agentPoolName) {
        return getWithResponse(resourceGroupName, resourceName, agentPoolName, Context.NONE).getValue();
    }

    /**
     * Creates or updates an agent pool in the specified managed cluster.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the managed cluster resource.
     * @param agentPoolName The name of the agent pool.
     * @param parameters The agent pool to create or update.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return agent Pool along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName,
        String resourceName, String agentPoolName, AgentPoolInner parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        if (agentPoolName == null) {
            return Mono.error(new IllegalArgumentException("Parameter agentPoolName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        } else {
            parameters.validate();
        }
        final String apiVersion = "2024-01-01";
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.createOrUpdate(this.client.getEndpoint(), apiVersion,
                this.client.getSubscriptionId(), resourceGroupName, resourceName, agentPoolName, parameters, accept,
                context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Creates or updates an agent pool in the specified managed cluster.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the managed cluster resource.
     * @param agentPoolName The name of the agent pool.
     * @param parameters The agent pool to create or update.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return agent Pool along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName,
        String resourceName, String agentPoolName, AgentPoolInner parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        if (agentPoolName == null) {
            return Mono.error(new IllegalArgumentException("Parameter agentPoolName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        } else {
            parameters.validate();
        }
        final String apiVersion = "2024-01-01";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.createOrUpdate(this.client.getEndpoint(), apiVersion, this.client.getSubscriptionId(),
            resourceGroupName, resourceName, agentPoolName, parameters, accept, context);
    }

    /**
     * Creates or updates an agent pool in the specified managed cluster.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the managed cluster resource.
     * @param agentPoolName The name of the agent pool.
     * @param parameters The agent pool to create or update.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of agent Pool.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<AgentPoolInner>, AgentPoolInner> beginCreateOrUpdateAsync(String resourceGroupName,
        String resourceName, String agentPoolName, AgentPoolInner parameters) {
        Mono<Response<Flux<ByteBuffer>>> mono
            = createOrUpdateWithResponseAsync(resourceGroupName, resourceName, agentPoolName, parameters);
        return this.client.<AgentPoolInner, AgentPoolInner>getLroResult(mono, this.client.getHttpPipeline(),
            AgentPoolInner.class, AgentPoolInner.class, this.client.getContext());
    }

    /**
     * Creates or updates an agent pool in the specified managed cluster.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the managed cluster resource.
     * @param agentPoolName The name of the agent pool.
     * @param parameters The agent pool to create or update.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of agent Pool.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<AgentPoolInner>, AgentPoolInner> beginCreateOrUpdateAsync(String resourceGroupName,
        String resourceName, String agentPoolName, AgentPoolInner parameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono
            = createOrUpdateWithResponseAsync(resourceGroupName, resourceName, agentPoolName, parameters, context);
        return this.client.<AgentPoolInner, AgentPoolInner>getLroResult(mono, this.client.getHttpPipeline(),
            AgentPoolInner.class, AgentPoolInner.class, context);
    }

    /**
     * Creates or updates an agent pool in the specified managed cluster.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the managed cluster resource.
     * @param agentPoolName The name of the agent pool.
     * @param parameters The agent pool to create or update.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of agent Pool.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<AgentPoolInner>, AgentPoolInner> beginCreateOrUpdate(String resourceGroupName,
        String resourceName, String agentPoolName, AgentPoolInner parameters) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, resourceName, agentPoolName, parameters)
            .getSyncPoller();
    }

    /**
     * Creates or updates an agent pool in the specified managed cluster.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the managed cluster resource.
     * @param agentPoolName The name of the agent pool.
     * @param parameters The agent pool to create or update.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of agent Pool.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<AgentPoolInner>, AgentPoolInner> beginCreateOrUpdate(String resourceGroupName,
        String resourceName, String agentPoolName, AgentPoolInner parameters, Context context) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, resourceName, agentPoolName, parameters, context)
            .getSyncPoller();
    }

    /**
     * Creates or updates an agent pool in the specified managed cluster.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the managed cluster resource.
     * @param agentPoolName The name of the agent pool.
     * @param parameters The agent pool to create or update.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return agent Pool on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<AgentPoolInner> createOrUpdateAsync(String resourceGroupName, String resourceName, String agentPoolName,
        AgentPoolInner parameters) {
        return beginCreateOrUpdateAsync(resourceGroupName, resourceName, agentPoolName, parameters).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Creates or updates an agent pool in the specified managed cluster.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the managed cluster resource.
     * @param agentPoolName The name of the agent pool.
     * @param parameters The agent pool to create or update.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return agent Pool on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<AgentPoolInner> createOrUpdateAsync(String resourceGroupName, String resourceName,
        String agentPoolName, AgentPoolInner parameters, Context context) {
        return beginCreateOrUpdateAsync(resourceGroupName, resourceName, agentPoolName, parameters, context).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Creates or updates an agent pool in the specified managed cluster.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the managed cluster resource.
     * @param agentPoolName The name of the agent pool.
     * @param parameters The agent pool to create or update.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return agent Pool.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public AgentPoolInner createOrUpdate(String resourceGroupName, String resourceName, String agentPoolName,
        AgentPoolInner parameters) {
        return createOrUpdateAsync(resourceGroupName, resourceName, agentPoolName, parameters).block();
    }

    /**
     * Creates or updates an agent pool in the specified managed cluster.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the managed cluster resource.
     * @param agentPoolName The name of the agent pool.
     * @param parameters The agent pool to create or update.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return agent Pool.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public AgentPoolInner createOrUpdate(String resourceGroupName, String resourceName, String agentPoolName,
        AgentPoolInner parameters, Context context) {
        return createOrUpdateAsync(resourceGroupName, resourceName, agentPoolName, parameters, context).block();
    }

    /**
     * Deletes an agent pool in the specified managed cluster.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the managed cluster resource.
     * @param agentPoolName The name of the agent pool.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String resourceName,
        String agentPoolName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        if (agentPoolName == null) {
            return Mono.error(new IllegalArgumentException("Parameter agentPoolName is required and cannot be null."));
        }
        final String apiVersion = "2024-01-01";
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.delete(this.client.getEndpoint(), apiVersion,
                this.client.getSubscriptionId(), resourceGroupName, resourceName, agentPoolName, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Deletes an agent pool in the specified managed cluster.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the managed cluster resource.
     * @param agentPoolName The name of the agent pool.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String resourceName,
        String agentPoolName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        if (agentPoolName == null) {
            return Mono.error(new IllegalArgumentException("Parameter agentPoolName is required and cannot be null."));
        }
        final String apiVersion = "2024-01-01";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.delete(this.client.getEndpoint(), apiVersion, this.client.getSubscriptionId(), resourceGroupName,
            resourceName, agentPoolName, accept, context);
    }

    /**
     * Deletes an agent pool in the specified managed cluster.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the managed cluster resource.
     * @param agentPoolName The name of the agent pool.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String resourceName,
        String agentPoolName) {
        Mono<Response<Flux<ByteBuffer>>> mono = deleteWithResponseAsync(resourceGroupName, resourceName, agentPoolName);
        return this.client.<Void, Void>getLroResult(mono, this.client.getHttpPipeline(), Void.class, Void.class,
            this.client.getContext());
    }

    /**
     * Deletes an agent pool in the specified managed cluster.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the managed cluster resource.
     * @param agentPoolName The name of the agent pool.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String resourceName,
        String agentPoolName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono
            = deleteWithResponseAsync(resourceGroupName, resourceName, agentPoolName, context);
        return this.client.<Void, Void>getLroResult(mono, this.client.getHttpPipeline(), Void.class, Void.class,
            context);
    }

    /**
     * Deletes an agent pool in the specified managed cluster.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the managed cluster resource.
     * @param agentPoolName The name of the agent pool.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String resourceName,
        String agentPoolName) {
        return this.beginDeleteAsync(resourceGroupName, resourceName, agentPoolName).getSyncPoller();
    }

    /**
     * Deletes an agent pool in the specified managed cluster.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the managed cluster resource.
     * @param agentPoolName The name of the agent pool.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String resourceName,
        String agentPoolName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, resourceName, agentPoolName, context).getSyncPoller();
    }

    /**
     * Deletes an agent pool in the specified managed cluster.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the managed cluster resource.
     * @param agentPoolName The name of the agent pool.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String resourceGroupName, String resourceName, String agentPoolName) {
        return beginDeleteAsync(resourceGroupName, resourceName, agentPoolName).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Deletes an agent pool in the specified managed cluster.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the managed cluster resource.
     * @param agentPoolName The name of the agent pool.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String resourceName, String agentPoolName,
        Context context) {
        return beginDeleteAsync(resourceGroupName, resourceName, agentPoolName, context).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Deletes an agent pool in the specified managed cluster.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the managed cluster resource.
     * @param agentPoolName The name of the agent pool.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void delete(String resourceGroupName, String resourceName, String agentPoolName) {
        deleteAsync(resourceGroupName, resourceName, agentPoolName).block();
    }

    /**
     * Deletes an agent pool in the specified managed cluster.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the managed cluster resource.
     * @param agentPoolName The name of the agent pool.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void delete(String resourceGroupName, String resourceName, String agentPoolName, Context context) {
        deleteAsync(resourceGroupName, resourceName, agentPoolName, context).block();
    }

    /**
     * Gets the upgrade profile for an agent pool.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the managed cluster resource.
     * @param agentPoolName The name of the agent pool.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the upgrade profile for an agent pool along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<AgentPoolUpgradeProfileInner>> getUpgradeProfileWithResponseAsync(String resourceGroupName,
        String resourceName, String agentPoolName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        if (agentPoolName == null) {
            return Mono.error(new IllegalArgumentException("Parameter agentPoolName is required and cannot be null."));
        }
        final String apiVersion = "2024-01-01";
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.getUpgradeProfile(this.client.getEndpoint(), apiVersion,
                this.client.getSubscriptionId(), resourceGroupName, resourceName, agentPoolName, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Gets the upgrade profile for an agent pool.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the managed cluster resource.
     * @param agentPoolName The name of the agent pool.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the upgrade profile for an agent pool along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<AgentPoolUpgradeProfileInner>> getUpgradeProfileWithResponseAsync(String resourceGroupName,
        String resourceName, String agentPoolName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        if (agentPoolName == null) {
            return Mono.error(new IllegalArgumentException("Parameter agentPoolName is required and cannot be null."));
        }
        final String apiVersion = "2024-01-01";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.getUpgradeProfile(this.client.getEndpoint(), apiVersion, this.client.getSubscriptionId(),
            resourceGroupName, resourceName, agentPoolName, accept, context);
    }

    /**
     * Gets the upgrade profile for an agent pool.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the managed cluster resource.
     * @param agentPoolName The name of the agent pool.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the upgrade profile for an agent pool on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<AgentPoolUpgradeProfileInner> getUpgradeProfileAsync(String resourceGroupName, String resourceName,
        String agentPoolName) {
        return getUpgradeProfileWithResponseAsync(resourceGroupName, resourceName, agentPoolName)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Gets the upgrade profile for an agent pool.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the managed cluster resource.
     * @param agentPoolName The name of the agent pool.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the upgrade profile for an agent pool along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<AgentPoolUpgradeProfileInner> getUpgradeProfileWithResponse(String resourceGroupName,
        String resourceName, String agentPoolName, Context context) {
        return getUpgradeProfileWithResponseAsync(resourceGroupName, resourceName, agentPoolName, context).block();
    }

    /**
     * Gets the upgrade profile for an agent pool.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the managed cluster resource.
     * @param agentPoolName The name of the agent pool.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the upgrade profile for an agent pool.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public AgentPoolUpgradeProfileInner getUpgradeProfile(String resourceGroupName, String resourceName,
        String agentPoolName) {
        return getUpgradeProfileWithResponse(resourceGroupName, resourceName, agentPoolName, Context.NONE).getValue();
    }

    /**
     * Gets a list of supported Kubernetes versions for the specified agent pool.
     * 
     * See [supported Kubernetes versions](https://docs.microsoft.com/azure/aks/supported-kubernetes-versions) for more
     * details about the version lifecycle.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the managed cluster resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the list of available versions for an agent pool along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<AgentPoolAvailableVersionsInner>>
        getAvailableAgentPoolVersionsWithResponseAsync(String resourceGroupName, String resourceName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        final String apiVersion = "2024-01-01";
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.getAvailableAgentPoolVersions(this.client.getEndpoint(), apiVersion,
                this.client.getSubscriptionId(), resourceGroupName, resourceName, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Gets a list of supported Kubernetes versions for the specified agent pool.
     * 
     * See [supported Kubernetes versions](https://docs.microsoft.com/azure/aks/supported-kubernetes-versions) for more
     * details about the version lifecycle.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the managed cluster resource.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the list of available versions for an agent pool along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<AgentPoolAvailableVersionsInner>>
        getAvailableAgentPoolVersionsWithResponseAsync(String resourceGroupName, String resourceName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        final String apiVersion = "2024-01-01";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.getAvailableAgentPoolVersions(this.client.getEndpoint(), apiVersion,
            this.client.getSubscriptionId(), resourceGroupName, resourceName, accept, context);
    }

    /**
     * Gets a list of supported Kubernetes versions for the specified agent pool.
     * 
     * See [supported Kubernetes versions](https://docs.microsoft.com/azure/aks/supported-kubernetes-versions) for more
     * details about the version lifecycle.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the managed cluster resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the list of available versions for an agent pool on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<AgentPoolAvailableVersionsInner> getAvailableAgentPoolVersionsAsync(String resourceGroupName,
        String resourceName) {
        return getAvailableAgentPoolVersionsWithResponseAsync(resourceGroupName, resourceName)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Gets a list of supported Kubernetes versions for the specified agent pool.
     * 
     * See [supported Kubernetes versions](https://docs.microsoft.com/azure/aks/supported-kubernetes-versions) for more
     * details about the version lifecycle.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the managed cluster resource.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the list of available versions for an agent pool along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<AgentPoolAvailableVersionsInner> getAvailableAgentPoolVersionsWithResponse(String resourceGroupName,
        String resourceName, Context context) {
        return getAvailableAgentPoolVersionsWithResponseAsync(resourceGroupName, resourceName, context).block();
    }

    /**
     * Gets a list of supported Kubernetes versions for the specified agent pool.
     * 
     * See [supported Kubernetes versions](https://docs.microsoft.com/azure/aks/supported-kubernetes-versions) for more
     * details about the version lifecycle.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the managed cluster resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the list of available versions for an agent pool.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public AgentPoolAvailableVersionsInner getAvailableAgentPoolVersions(String resourceGroupName,
        String resourceName) {
        return getAvailableAgentPoolVersionsWithResponse(resourceGroupName, resourceName, Context.NONE).getValue();
    }

    /**
     * Upgrades the node image version of an agent pool to the latest.
     * 
     * Upgrading the node image version of an agent pool applies the newest OS and runtime updates to the nodes. AKS
     * provides one new image per week with the latest updates. For more details on node image versions, see:
     * https://docs.microsoft.com/azure/aks/node-image-upgrade.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the managed cluster resource.
     * @param agentPoolName The name of the agent pool.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response body along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> upgradeNodeImageVersionWithResponseAsync(String resourceGroupName,
        String resourceName, String agentPoolName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        if (agentPoolName == null) {
            return Mono.error(new IllegalArgumentException("Parameter agentPoolName is required and cannot be null."));
        }
        final String apiVersion = "2024-01-01";
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.upgradeNodeImageVersion(this.client.getEndpoint(), apiVersion,
                this.client.getSubscriptionId(), resourceGroupName, resourceName, agentPoolName, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Upgrades the node image version of an agent pool to the latest.
     * 
     * Upgrading the node image version of an agent pool applies the newest OS and runtime updates to the nodes. AKS
     * provides one new image per week with the latest updates. For more details on node image versions, see:
     * https://docs.microsoft.com/azure/aks/node-image-upgrade.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the managed cluster resource.
     * @param agentPoolName The name of the agent pool.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response body along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> upgradeNodeImageVersionWithResponseAsync(String resourceGroupName,
        String resourceName, String agentPoolName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        if (agentPoolName == null) {
            return Mono.error(new IllegalArgumentException("Parameter agentPoolName is required and cannot be null."));
        }
        final String apiVersion = "2024-01-01";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.upgradeNodeImageVersion(this.client.getEndpoint(), apiVersion, this.client.getSubscriptionId(),
            resourceGroupName, resourceName, agentPoolName, accept, context);
    }

    /**
     * Upgrades the node image version of an agent pool to the latest.
     * 
     * Upgrading the node image version of an agent pool applies the newest OS and runtime updates to the nodes. AKS
     * provides one new image per week with the latest updates. For more details on node image versions, see:
     * https://docs.microsoft.com/azure/aks/node-image-upgrade.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the managed cluster resource.
     * @param agentPoolName The name of the agent pool.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<AgentPoolInner>, AgentPoolInner>
        beginUpgradeNodeImageVersionAsync(String resourceGroupName, String resourceName, String agentPoolName) {
        Mono<Response<Flux<ByteBuffer>>> mono
            = upgradeNodeImageVersionWithResponseAsync(resourceGroupName, resourceName, agentPoolName);
        return this.client.<AgentPoolInner, AgentPoolInner>getLroResult(mono, this.client.getHttpPipeline(),
            AgentPoolInner.class, AgentPoolInner.class, this.client.getContext());
    }

    /**
     * Upgrades the node image version of an agent pool to the latest.
     * 
     * Upgrading the node image version of an agent pool applies the newest OS and runtime updates to the nodes. AKS
     * provides one new image per week with the latest updates. For more details on node image versions, see:
     * https://docs.microsoft.com/azure/aks/node-image-upgrade.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the managed cluster resource.
     * @param agentPoolName The name of the agent pool.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<AgentPoolInner>, AgentPoolInner> beginUpgradeNodeImageVersionAsync(
        String resourceGroupName, String resourceName, String agentPoolName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono
            = upgradeNodeImageVersionWithResponseAsync(resourceGroupName, resourceName, agentPoolName, context);
        return this.client.<AgentPoolInner, AgentPoolInner>getLroResult(mono, this.client.getHttpPipeline(),
            AgentPoolInner.class, AgentPoolInner.class, context);
    }

    /**
     * Upgrades the node image version of an agent pool to the latest.
     * 
     * Upgrading the node image version of an agent pool applies the newest OS and runtime updates to the nodes. AKS
     * provides one new image per week with the latest updates. For more details on node image versions, see:
     * https://docs.microsoft.com/azure/aks/node-image-upgrade.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the managed cluster resource.
     * @param agentPoolName The name of the agent pool.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<AgentPoolInner>, AgentPoolInner> beginUpgradeNodeImageVersion(String resourceGroupName,
        String resourceName, String agentPoolName) {
        return this.beginUpgradeNodeImageVersionAsync(resourceGroupName, resourceName, agentPoolName).getSyncPoller();
    }

    /**
     * Upgrades the node image version of an agent pool to the latest.
     * 
     * Upgrading the node image version of an agent pool applies the newest OS and runtime updates to the nodes. AKS
     * provides one new image per week with the latest updates. For more details on node image versions, see:
     * https://docs.microsoft.com/azure/aks/node-image-upgrade.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the managed cluster resource.
     * @param agentPoolName The name of the agent pool.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<AgentPoolInner>, AgentPoolInner> beginUpgradeNodeImageVersion(String resourceGroupName,
        String resourceName, String agentPoolName, Context context) {
        return this.beginUpgradeNodeImageVersionAsync(resourceGroupName, resourceName, agentPoolName, context)
            .getSyncPoller();
    }

    /**
     * Upgrades the node image version of an agent pool to the latest.
     * 
     * Upgrading the node image version of an agent pool applies the newest OS and runtime updates to the nodes. AKS
     * provides one new image per week with the latest updates. For more details on node image versions, see:
     * https://docs.microsoft.com/azure/aks/node-image-upgrade.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the managed cluster resource.
     * @param agentPoolName The name of the agent pool.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response body on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<AgentPoolInner> upgradeNodeImageVersionAsync(String resourceGroupName, String resourceName,
        String agentPoolName) {
        return beginUpgradeNodeImageVersionAsync(resourceGroupName, resourceName, agentPoolName).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Upgrades the node image version of an agent pool to the latest.
     * 
     * Upgrading the node image version of an agent pool applies the newest OS and runtime updates to the nodes. AKS
     * provides one new image per week with the latest updates. For more details on node image versions, see:
     * https://docs.microsoft.com/azure/aks/node-image-upgrade.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the managed cluster resource.
     * @param agentPoolName The name of the agent pool.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response body on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<AgentPoolInner> upgradeNodeImageVersionAsync(String resourceGroupName, String resourceName,
        String agentPoolName, Context context) {
        return beginUpgradeNodeImageVersionAsync(resourceGroupName, resourceName, agentPoolName, context).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Upgrades the node image version of an agent pool to the latest.
     * 
     * Upgrading the node image version of an agent pool applies the newest OS and runtime updates to the nodes. AKS
     * provides one new image per week with the latest updates. For more details on node image versions, see:
     * https://docs.microsoft.com/azure/aks/node-image-upgrade.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the managed cluster resource.
     * @param agentPoolName The name of the agent pool.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public AgentPoolInner upgradeNodeImageVersion(String resourceGroupName, String resourceName, String agentPoolName) {
        return upgradeNodeImageVersionAsync(resourceGroupName, resourceName, agentPoolName).block();
    }

    /**
     * Upgrades the node image version of an agent pool to the latest.
     * 
     * Upgrading the node image version of an agent pool applies the newest OS and runtime updates to the nodes. AKS
     * provides one new image per week with the latest updates. For more details on node image versions, see:
     * https://docs.microsoft.com/azure/aks/node-image-upgrade.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the managed cluster resource.
     * @param agentPoolName The name of the agent pool.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public AgentPoolInner upgradeNodeImageVersion(String resourceGroupName, String resourceName, String agentPoolName,
        Context context) {
        return upgradeNodeImageVersionAsync(resourceGroupName, resourceName, agentPoolName, context).block();
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items
     * 
     * The nextLink parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response from the List Agent Pools operation along with {@link PagedResponse} on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<AgentPoolInner>> listNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil.withContext(context -> service.listNext(nextLink, this.client.getEndpoint(), accept, context))
            .<PagedResponse<AgentPoolInner>>map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(),
                res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items
     * 
     * The nextLink parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response from the List Agent Pools operation along with {@link PagedResponse} on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<AgentPoolInner>> listNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.listNext(nextLink, this.client.getEndpoint(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }
}
