// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.containerservice.models.OSOptionProperty;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/**
 * The list of OS option properties.
 */
@Fluent
public final class OSOptionPropertyList {
    /*
     * The list of OS options.
     */
    @JsonProperty(value = "osOptionPropertyList", required = true)
    private List<OSOptionProperty> osOptionPropertyList;

    /**
     * Creates an instance of OSOptionPropertyList class.
     */
    public OSOptionPropertyList() {
    }

    /**
     * Get the osOptionPropertyList property: The list of OS options.
     * 
     * @return the osOptionPropertyList value.
     */
    public List<OSOptionProperty> osOptionPropertyList() {
        return this.osOptionPropertyList;
    }

    /**
     * Set the osOptionPropertyList property: The list of OS options.
     * 
     * @param osOptionPropertyList the osOptionPropertyList value to set.
     * @return the OSOptionPropertyList object itself.
     */
    public OSOptionPropertyList withOsOptionPropertyList(List<OSOptionProperty> osOptionPropertyList) {
        this.osOptionPropertyList = osOptionPropertyList;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (osOptionPropertyList() == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                "Missing required property osOptionPropertyList in model OSOptionPropertyList"));
        } else {
            osOptionPropertyList().forEach(e -> e.validate());
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(OSOptionPropertyList.class);
}
