// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.containerservice.models.AgentPoolAvailableVersionsPropertiesAgentPoolVersionsItem;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/**
 * The list of available versions for an agent pool.
 */
@Fluent
public final class AgentPoolAvailableVersionsInner {
    /*
     * The ID of the agent pool version list.
     */
    @JsonProperty(value = "id", access = JsonProperty.Access.WRITE_ONLY)
    private String id;

    /*
     * The name of the agent pool version list.
     */
    @JsonProperty(value = "name", access = JsonProperty.Access.WRITE_ONLY)
    private String name;

    /*
     * Type of the agent pool version list.
     */
    @JsonProperty(value = "type", access = JsonProperty.Access.WRITE_ONLY)
    private String type;

    /*
     * Properties of agent pool available versions.
     */
    @JsonProperty(value = "properties", required = true)
    private AgentPoolAvailableVersionsProperties innerProperties = new AgentPoolAvailableVersionsProperties();

    /**
     * Creates an instance of AgentPoolAvailableVersionsInner class.
     */
    public AgentPoolAvailableVersionsInner() {
    }

    /**
     * Get the id property: The ID of the agent pool version list.
     * 
     * @return the id value.
     */
    public String id() {
        return this.id;
    }

    /**
     * Get the name property: The name of the agent pool version list.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Get the type property: Type of the agent pool version list.
     * 
     * @return the type value.
     */
    public String type() {
        return this.type;
    }

    /**
     * Get the innerProperties property: Properties of agent pool available versions.
     * 
     * @return the innerProperties value.
     */
    private AgentPoolAvailableVersionsProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the agentPoolVersions property: List of versions available for agent pool.
     * 
     * @return the agentPoolVersions value.
     */
    public List<AgentPoolAvailableVersionsPropertiesAgentPoolVersionsItem> agentPoolVersions() {
        return this.innerProperties() == null ? null : this.innerProperties().agentPoolVersions();
    }

    /**
     * Set the agentPoolVersions property: List of versions available for agent pool.
     * 
     * @param agentPoolVersions the agentPoolVersions value to set.
     * @return the AgentPoolAvailableVersionsInner object itself.
     */
    public AgentPoolAvailableVersionsInner
        withAgentPoolVersions(List<AgentPoolAvailableVersionsPropertiesAgentPoolVersionsItem> agentPoolVersions) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AgentPoolAvailableVersionsProperties();
        }
        this.innerProperties().withAgentPoolVersions(agentPoolVersions);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                "Missing required property innerProperties in model AgentPoolAvailableVersionsInner"));
        } else {
            innerProperties().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(AgentPoolAvailableVersionsInner.class);
}
