// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonProperty;

/** For schedules like: 'recur every Monday' or 'recur every 3 weeks on Wednesday'. */
@Fluent
public final class WeeklySchedule {
    /*
     * Specifies the number of weeks between each set of occurrences.
     */
    @JsonProperty(value = "intervalWeeks", required = true)
    private int intervalWeeks;

    /*
     * Specifies on which day of the week the maintenance occurs.
     */
    @JsonProperty(value = "dayOfWeek", required = true)
    private WeekDay dayOfWeek;

    /** Creates an instance of WeeklySchedule class. */
    public WeeklySchedule() {
    }

    /**
     * Get the intervalWeeks property: Specifies the number of weeks between each set of occurrences.
     *
     * @return the intervalWeeks value.
     */
    public int intervalWeeks() {
        return this.intervalWeeks;
    }

    /**
     * Set the intervalWeeks property: Specifies the number of weeks between each set of occurrences.
     *
     * @param intervalWeeks the intervalWeeks value to set.
     * @return the WeeklySchedule object itself.
     */
    public WeeklySchedule withIntervalWeeks(int intervalWeeks) {
        this.intervalWeeks = intervalWeeks;
        return this;
    }

    /**
     * Get the dayOfWeek property: Specifies on which day of the week the maintenance occurs.
     *
     * @return the dayOfWeek value.
     */
    public WeekDay dayOfWeek() {
        return this.dayOfWeek;
    }

    /**
     * Set the dayOfWeek property: Specifies on which day of the week the maintenance occurs.
     *
     * @param dayOfWeek the dayOfWeek value to set.
     * @return the WeeklySchedule object itself.
     */
    public WeeklySchedule withDayOfWeek(WeekDay dayOfWeek) {
        this.dayOfWeek = dayOfWeek;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (dayOfWeek() == null) {
            throw LOGGER
                .logExceptionAsError(
                    new IllegalArgumentException("Missing required property dayOfWeek in model WeeklySchedule"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(WeeklySchedule.class);
}
