// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** Desired outbound IP Prefix resources for the cluster load balancer. */
@Fluent
public final class ManagedClusterLoadBalancerProfileOutboundIpPrefixes {
    /*
     * A list of public IP prefix resources.
     */
    @JsonProperty(value = "publicIPPrefixes")
    private List<ResourceReference> publicIpPrefixes;

    /** Creates an instance of ManagedClusterLoadBalancerProfileOutboundIpPrefixes class. */
    public ManagedClusterLoadBalancerProfileOutboundIpPrefixes() {
    }

    /**
     * Get the publicIpPrefixes property: A list of public IP prefix resources.
     *
     * @return the publicIpPrefixes value.
     */
    public List<ResourceReference> publicIpPrefixes() {
        return this.publicIpPrefixes;
    }

    /**
     * Set the publicIpPrefixes property: A list of public IP prefix resources.
     *
     * @param publicIpPrefixes the publicIpPrefixes value to set.
     * @return the ManagedClusterLoadBalancerProfileOutboundIpPrefixes object itself.
     */
    public ManagedClusterLoadBalancerProfileOutboundIpPrefixes withPublicIpPrefixes(
        List<ResourceReference> publicIpPrefixes) {
        this.publicIpPrefixes = publicIpPrefixes;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (publicIpPrefixes() != null) {
            publicIpPrefixes().forEach(e -> e.validate());
        }
    }
}
