// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Desired managed outbound IPs for the cluster load balancer. */
@Fluent
public final class ManagedClusterLoadBalancerProfileManagedOutboundIPs {
    /*
     * The desired number of IPv4 outbound IPs created/managed by Azure for the cluster load balancer. Allowed values
     * must be in the range of 1 to 100 (inclusive). The default value is 1.
     */
    @JsonProperty(value = "count")
    private Integer count;

    /*
     * The desired number of IPv6 outbound IPs created/managed by Azure for the cluster load balancer. Allowed values
     * must be in the range of 1 to 100 (inclusive). The default value is 0 for single-stack and 1 for dual-stack.
     */
    @JsonProperty(value = "countIPv6")
    private Integer countIPv6;

    /** Creates an instance of ManagedClusterLoadBalancerProfileManagedOutboundIPs class. */
    public ManagedClusterLoadBalancerProfileManagedOutboundIPs() {
    }

    /**
     * Get the count property: The desired number of IPv4 outbound IPs created/managed by Azure for the cluster load
     * balancer. Allowed values must be in the range of 1 to 100 (inclusive). The default value is 1.
     *
     * @return the count value.
     */
    public Integer count() {
        return this.count;
    }

    /**
     * Set the count property: The desired number of IPv4 outbound IPs created/managed by Azure for the cluster load
     * balancer. Allowed values must be in the range of 1 to 100 (inclusive). The default value is 1.
     *
     * @param count the count value to set.
     * @return the ManagedClusterLoadBalancerProfileManagedOutboundIPs object itself.
     */
    public ManagedClusterLoadBalancerProfileManagedOutboundIPs withCount(Integer count) {
        this.count = count;
        return this;
    }

    /**
     * Get the countIPv6 property: The desired number of IPv6 outbound IPs created/managed by Azure for the cluster load
     * balancer. Allowed values must be in the range of 1 to 100 (inclusive). The default value is 0 for single-stack
     * and 1 for dual-stack.
     *
     * @return the countIPv6 value.
     */
    public Integer countIPv6() {
        return this.countIPv6;
    }

    /**
     * Set the countIPv6 property: The desired number of IPv6 outbound IPs created/managed by Azure for the cluster load
     * balancer. Allowed values must be in the range of 1 to 100 (inclusive). The default value is 0 for single-stack
     * and 1 for dual-stack.
     *
     * @param countIPv6 the countIPv6 value to set.
     * @return the ManagedClusterLoadBalancerProfileManagedOutboundIPs object itself.
     */
    public ManagedClusterLoadBalancerProfileManagedOutboundIPs withCountIPv6(Integer countIPv6) {
        this.countIPv6 = countIPv6;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
