// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Azure Monitor addon profiles for monitoring the managed cluster. */
@Fluent
public final class ManagedClusterAzureMonitorProfile {
    /*
     * Metrics profile for the Azure Monitor managed service for Prometheus addon. Collect out-of-the-box Kubernetes
     * infrastructure metrics to send to an Azure Monitor Workspace and configure additional scraping for custom
     * targets. See aka.ms/AzureManagedPrometheus for an overview.
     */
    @JsonProperty(value = "metrics")
    private ManagedClusterAzureMonitorProfileMetrics metrics;

    /** Creates an instance of ManagedClusterAzureMonitorProfile class. */
    public ManagedClusterAzureMonitorProfile() {
    }

    /**
     * Get the metrics property: Metrics profile for the Azure Monitor managed service for Prometheus addon. Collect
     * out-of-the-box Kubernetes infrastructure metrics to send to an Azure Monitor Workspace and configure additional
     * scraping for custom targets. See aka.ms/AzureManagedPrometheus for an overview.
     *
     * @return the metrics value.
     */
    public ManagedClusterAzureMonitorProfileMetrics metrics() {
        return this.metrics;
    }

    /**
     * Set the metrics property: Metrics profile for the Azure Monitor managed service for Prometheus addon. Collect
     * out-of-the-box Kubernetes infrastructure metrics to send to an Azure Monitor Workspace and configure additional
     * scraping for custom targets. See aka.ms/AzureManagedPrometheus for an overview.
     *
     * @param metrics the metrics value to set.
     * @return the ManagedClusterAzureMonitorProfile object itself.
     */
    public ManagedClusterAzureMonitorProfile withMetrics(ManagedClusterAzureMonitorProfileMetrics metrics) {
        this.metrics = metrics;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (metrics() != null) {
            metrics().validate();
        }
    }
}
