// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;

/** A Kubernetes add-on profile for a managed cluster. */
@Fluent
public final class ManagedClusterAddonProfile {
    /*
     * Whether the add-on is enabled or not.
     */
    @JsonProperty(value = "enabled", required = true)
    private boolean enabled;

    /*
     * Key-value pairs for configuring an add-on.
     */
    @JsonProperty(value = "config")
    @JsonInclude(value = JsonInclude.Include.NON_NULL, content = JsonInclude.Include.ALWAYS)
    private Map<String, String> config;

    /*
     * Information of user assigned identity used by this add-on.
     */
    @JsonProperty(value = "identity", access = JsonProperty.Access.WRITE_ONLY)
    private ManagedClusterAddonProfileIdentity identity;

    /** Creates an instance of ManagedClusterAddonProfile class. */
    public ManagedClusterAddonProfile() {
    }

    /**
     * Get the enabled property: Whether the add-on is enabled or not.
     *
     * @return the enabled value.
     */
    public boolean enabled() {
        return this.enabled;
    }

    /**
     * Set the enabled property: Whether the add-on is enabled or not.
     *
     * @param enabled the enabled value to set.
     * @return the ManagedClusterAddonProfile object itself.
     */
    public ManagedClusterAddonProfile withEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    /**
     * Get the config property: Key-value pairs for configuring an add-on.
     *
     * @return the config value.
     */
    public Map<String, String> config() {
        return this.config;
    }

    /**
     * Set the config property: Key-value pairs for configuring an add-on.
     *
     * @param config the config value to set.
     * @return the ManagedClusterAddonProfile object itself.
     */
    public ManagedClusterAddonProfile withConfig(Map<String, String> config) {
        this.config = config;
        return this;
    }

    /**
     * Get the identity property: Information of user assigned identity used by this add-on.
     *
     * @return the identity value.
     */
    public ManagedClusterAddonProfileIdentity identity() {
        return this.identity;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (identity() != null) {
            identity().validate();
        }
    }
}
