// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** Kubernetes patch version profile. */
@Fluent
public final class KubernetesPatchVersion {
    /*
     * Possible upgrade path for given patch version
     */
    @JsonProperty(value = "upgrades")
    private List<String> upgrades;

    /** Creates an instance of KubernetesPatchVersion class. */
    public KubernetesPatchVersion() {
    }

    /**
     * Get the upgrades property: Possible upgrade path for given patch version.
     *
     * @return the upgrades value.
     */
    public List<String> upgrades() {
        return this.upgrades;
    }

    /**
     * Set the upgrades property: Possible upgrade path for given patch version.
     *
     * @param upgrades the upgrades value to set.
     * @return the KubernetesPatchVersion object itself.
     */
    public KubernetesPatchVersion withUpgrades(List<String> upgrades) {
        this.upgrades = upgrades;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
