// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/** connect information from the AKS agent nodes to a single endpoint. */
@Fluent
public final class EndpointDetail {
    /*
     * An IP Address that Domain Name currently resolves to.
     */
    @JsonProperty(value = "ipAddress")
    private String ipAddress;

    /*
     * The port an endpoint is connected to.
     */
    @JsonProperty(value = "port")
    private Integer port;

    /*
     * The protocol used for connection
     */
    @JsonProperty(value = "protocol")
    private String protocol;

    /*
     * Description of the detail
     */
    @JsonProperty(value = "description")
    private String description;

    /** Creates an instance of EndpointDetail class. */
    public EndpointDetail() {
    }

    /**
     * Get the ipAddress property: An IP Address that Domain Name currently resolves to.
     *
     * @return the ipAddress value.
     */
    public String ipAddress() {
        return this.ipAddress;
    }

    /**
     * Set the ipAddress property: An IP Address that Domain Name currently resolves to.
     *
     * @param ipAddress the ipAddress value to set.
     * @return the EndpointDetail object itself.
     */
    public EndpointDetail withIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
        return this;
    }

    /**
     * Get the port property: The port an endpoint is connected to.
     *
     * @return the port value.
     */
    public Integer port() {
        return this.port;
    }

    /**
     * Set the port property: The port an endpoint is connected to.
     *
     * @param port the port value to set.
     * @return the EndpointDetail object itself.
     */
    public EndpointDetail withPort(Integer port) {
        this.port = port;
        return this;
    }

    /**
     * Get the protocol property: The protocol used for connection.
     *
     * @return the protocol value.
     */
    public String protocol() {
        return this.protocol;
    }

    /**
     * Set the protocol property: The protocol used for connection.
     *
     * @param protocol the protocol value to set.
     * @return the EndpointDetail object itself.
     */
    public EndpointDetail withProtocol(String protocol) {
        this.protocol = protocol;
        return this;
    }

    /**
     * Get the description property: Description of the detail.
     *
     * @return the description value.
     */
    public String description() {
        return this.description;
    }

    /**
     * Set the description property: Description of the detail.
     *
     * @param description the description value to set.
     * @return the EndpointDetail object itself.
     */
    public EndpointDetail withDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
