// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.LocalDate;

/**
 * A date range.
 *
 * <p>For example, between '2022-12-23' and '2023-01-05'.
 */
@Fluent
public final class DateSpan {
    /*
     * The start date of the date span.
     */
    @JsonProperty(value = "start", required = true)
    private LocalDate start;

    /*
     * The end date of the date span.
     */
    @JsonProperty(value = "end", required = true)
    private LocalDate end;

    /** Creates an instance of DateSpan class. */
    public DateSpan() {
    }

    /**
     * Get the start property: The start date of the date span.
     *
     * @return the start value.
     */
    public LocalDate start() {
        return this.start;
    }

    /**
     * Set the start property: The start date of the date span.
     *
     * @param start the start value to set.
     * @return the DateSpan object itself.
     */
    public DateSpan withStart(LocalDate start) {
        this.start = start;
        return this;
    }

    /**
     * Get the end property: The end date of the date span.
     *
     * @return the end value.
     */
    public LocalDate end() {
        return this.end;
    }

    /**
     * Set the end property: The end date of the date span.
     *
     * @param end the end value to set.
     * @return the DateSpan object itself.
     */
    public DateSpan withEnd(LocalDate end) {
        this.end = end;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (start() == null) {
            throw LOGGER
                .logExceptionAsError(new IllegalArgumentException("Missing required property start in model DateSpan"));
        }
        if (end() == null) {
            throw LOGGER
                .logExceptionAsError(new IllegalArgumentException("Missing required property end in model DateSpan"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(DateSpan.class);
}
