/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerservice.models;

import com.azure.resourcemanager.containerservice.fluent.models.AgentPoolInner;
import com.azure.resourcemanager.containerservice.models.AgentPool;
import com.azure.resourcemanager.containerservice.models.AgentPoolMode;
import com.azure.resourcemanager.containerservice.models.AgentPoolType;
import com.azure.resourcemanager.containerservice.models.ContainerServiceVMSizeTypes;
import com.azure.resourcemanager.containerservice.models.KubeletDiskType;
import com.azure.resourcemanager.containerservice.models.OSDiskType;
import com.azure.resourcemanager.containerservice.models.OSType;
import com.azure.resourcemanager.containerservice.models.PowerState;
import com.azure.resourcemanager.containerservice.models.ScaleSetEvictionPolicy;
import com.azure.resourcemanager.containerservice.models.ScaleSetPriority;
import com.azure.resourcemanager.resources.fluentcore.arm.ResourceUtils;
import com.azure.resourcemanager.resources.fluentcore.model.HasInnerModel;
import com.azure.resourcemanager.resources.fluentcore.utils.ResourceManagerUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;

public class AgentPoolData
implements AgentPool,
HasInnerModel<AgentPoolInner> {
    private final AgentPoolInner innerModel;

    public AgentPoolData() {
        this(new AgentPoolInner());
    }

    protected AgentPoolData(AgentPoolInner innerModel) {
        this.innerModel = innerModel;
    }

    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String provisioningState() {
        return this.innerModel().provisioningState();
    }

    @Override
    public int count() {
        return ResourceManagerUtils.toPrimitiveInt((Integer)this.innerModel().count());
    }

    @Override
    public ContainerServiceVMSizeTypes vmSize() {
        return ContainerServiceVMSizeTypes.fromString(this.innerModel().vmSize());
    }

    @Override
    public int osDiskSizeInGB() {
        return ResourceManagerUtils.toPrimitiveInt((Integer)this.innerModel().osDiskSizeGB());
    }

    @Override
    public OSType osType() {
        return this.innerModel().osType();
    }

    @Override
    public AgentPoolType type() {
        return this.innerModel().typePropertiesType();
    }

    @Override
    public AgentPoolMode mode() {
        return this.innerModel().mode();
    }

    @Override
    public String subnetName() {
        return ResourceUtils.nameFromResourceId((String)this.innerModel().vnetSubnetId());
    }

    @Override
    public String networkId() {
        String subnetId = this.innerModel() != null ? this.innerModel().vnetSubnetId() : null;
        return subnetId != null ? ResourceUtils.parentResourceIdFromResourceId((String)subnetId) : null;
    }

    @Override
    public List<String> availabilityZones() {
        return this.innerModel().availabilityZones();
    }

    @Override
    public Map<String, String> nodeLabels() {
        return this.innerModel().nodeLabels() == null ? null : Collections.unmodifiableMap(this.innerModel().nodeLabels());
    }

    @Override
    public List<String> nodeTaints() {
        return this.innerModel().nodeTaints() == null ? null : Collections.unmodifiableList(this.innerModel().nodeTaints());
    }

    @Override
    public PowerState powerState() {
        return this.innerModel().powerState();
    }

    @Override
    public int nodeSize() {
        return ResourceManagerUtils.toPrimitiveInt((Integer)this.innerModel().count());
    }

    @Override
    public int maximumPodsPerNode() {
        return ResourceManagerUtils.toPrimitiveInt((Integer)this.innerModel().maxPods());
    }

    @Override
    public boolean isAutoScalingEnabled() {
        return ResourceManagerUtils.toPrimitiveBoolean((Boolean)this.innerModel().enableAutoScaling());
    }

    @Override
    public int minimumNodeSize() {
        return ResourceManagerUtils.toPrimitiveInt((Integer)this.innerModel().minCount());
    }

    @Override
    public int maximumNodeSize() {
        return ResourceManagerUtils.toPrimitiveInt((Integer)this.innerModel().maxCount());
    }

    @Override
    public ScaleSetPriority virtualMachinePriority() {
        return this.innerModel().scaleSetPriority();
    }

    @Override
    public ScaleSetEvictionPolicy virtualMachineEvictionPolicy() {
        return this.innerModel().scaleSetEvictionPolicy();
    }

    @Override
    public Double virtualMachineMaximumPrice() {
        return this.innerModel().spotMaxPrice().doubleValue();
    }

    @Override
    public OSDiskType osDiskType() {
        return this.innerModel().osDiskType();
    }

    @Override
    public KubeletDiskType kubeletDiskType() {
        return this.innerModel().kubeletDiskType();
    }

    @Override
    public Map<String, String> tags() {
        return this.innerModel().tags();
    }

    public AgentPoolData withVirtualMachineSize(ContainerServiceVMSizeTypes vmSize) {
        this.innerModel().withVmSize(vmSize.toString());
        return this;
    }

    public AgentPoolData withOSType(OSType osType) {
        this.innerModel().withOsType(osType);
        return this;
    }

    public AgentPoolData withOSDiskSizeInGB(int osDiskSizeInGB) {
        this.innerModel().withOsDiskSizeGB(osDiskSizeInGB);
        return this;
    }

    public AgentPoolData withAgentPoolType(AgentPoolType agentPoolType) {
        this.innerModel().withTypePropertiesType(agentPoolType);
        return this;
    }

    public AgentPoolData withAgentPoolTypeName(String agentPoolTypeName) {
        this.innerModel().withTypePropertiesType(AgentPoolType.fromString(agentPoolTypeName));
        return this;
    }

    public AgentPoolData withAgentPoolVirtualMachineCount(int count) {
        this.innerModel().withCount(count);
        return this;
    }

    public AgentPoolData withMaxPodsCount(int podsCount) {
        this.innerModel().withMaxPods(podsCount);
        return this;
    }

    public AgentPoolData withVirtualNetwork(String virtualNetworkId, String subnetName) {
        String vnetSubnetId = virtualNetworkId + "/subnets/" + subnetName;
        this.innerModel().withVnetSubnetId(vnetSubnetId);
        return this;
    }

    public AgentPoolData withAgentPoolMode(AgentPoolMode agentPoolMode) {
        this.innerModel().withMode(agentPoolMode);
        return this;
    }

    public AgentPoolData withAutoScaling(int minimumNodeSize, int maximumNodeSize) {
        this.innerModel().withEnableAutoScaling(true);
        this.innerModel().withMinCount(minimumNodeSize);
        this.innerModel().withMaxCount(maximumNodeSize);
        return this;
    }

    public AgentPoolData withAvailabilityZones(Integer ... zones) {
        this.innerModel().withAvailabilityZones(Arrays.stream(zones).map(String::valueOf).collect(Collectors.toList()));
        return this;
    }

    public AgentPoolData withNodeLabels(Map<String, String> nodeLabels) {
        this.innerModel().withNodeLabels((Map<String, String>)(nodeLabels == null ? null : new TreeMap<String, String>(nodeLabels)));
        return this;
    }

    public AgentPoolData withNodeTaints(List<String> nodeTaints) {
        this.innerModel().withNodeTaints(nodeTaints);
        return this;
    }

    public AgentPoolData withVirtualMachinePriority(ScaleSetPriority priority) {
        this.innerModel().withScaleSetPriority(priority);
        return this;
    }

    public AgentPoolData withSpotPriorityVirtualMachine() {
        this.innerModel().withScaleSetPriority(ScaleSetPriority.SPOT);
        return this;
    }

    public AgentPoolData withSpotPriorityVirtualMachine(ScaleSetEvictionPolicy policy) {
        this.innerModel().withScaleSetPriority(ScaleSetPriority.SPOT);
        this.innerModel().withScaleSetEvictionPolicy(policy);
        return this;
    }

    public AgentPoolData withVirtualMachineMaximumPrice(Double maxPriceInUsDollars) {
        this.innerModel().withSpotMaxPrice(Float.valueOf(maxPriceInUsDollars.floatValue()));
        return this;
    }

    public AgentPoolData withOSDiskType(OSDiskType osDiskType) {
        this.innerModel().withOsDiskType(osDiskType);
        return this;
    }

    public AgentPoolData withKubeletDiskType(KubeletDiskType kubeletDiskType) {
        this.innerModel().withKubeletDiskType(kubeletDiskType);
        return this;
    }

    public AgentPoolData withTags(Map<String, String> tags) {
        this.innerModel().withTags(tags);
        return this;
    }

    public AgentPoolData withTag(String key, String value) {
        if (this.innerModel().tags() == null) {
            this.innerModel().withTags(new TreeMap<String, String>());
        }
        this.innerModel().tags().put(key, value);
        return this;
    }

    public AgentPoolInner innerModel() {
        return this.innerModel;
    }
}

