// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Security profile for the container service cluster. */
@Fluent
public final class ManagedClusterSecurityProfile {
    /*
     * Microsoft Defender settings for the security profile.
     */
    @JsonProperty(value = "defender")
    private ManagedClusterSecurityProfileDefender defender;

    /*
     * Azure Key Vault [key management service](https://kubernetes.io/docs/tasks/administer-cluster/kms-provider/)
     * settings for the security profile.
     */
    @JsonProperty(value = "azureKeyVaultKms")
    private AzureKeyVaultKms azureKeyVaultKms;

    /** Creates an instance of ManagedClusterSecurityProfile class. */
    public ManagedClusterSecurityProfile() {
    }

    /**
     * Get the defender property: Microsoft Defender settings for the security profile.
     *
     * @return the defender value.
     */
    public ManagedClusterSecurityProfileDefender defender() {
        return this.defender;
    }

    /**
     * Set the defender property: Microsoft Defender settings for the security profile.
     *
     * @param defender the defender value to set.
     * @return the ManagedClusterSecurityProfile object itself.
     */
    public ManagedClusterSecurityProfile withDefender(ManagedClusterSecurityProfileDefender defender) {
        this.defender = defender;
        return this;
    }

    /**
     * Get the azureKeyVaultKms property: Azure Key Vault [key management
     * service](https://kubernetes.io/docs/tasks/administer-cluster/kms-provider/) settings for the security profile.
     *
     * @return the azureKeyVaultKms value.
     */
    public AzureKeyVaultKms azureKeyVaultKms() {
        return this.azureKeyVaultKms;
    }

    /**
     * Set the azureKeyVaultKms property: Azure Key Vault [key management
     * service](https://kubernetes.io/docs/tasks/administer-cluster/kms-provider/) settings for the security profile.
     *
     * @param azureKeyVaultKms the azureKeyVaultKms value to set.
     * @return the ManagedClusterSecurityProfile object itself.
     */
    public ManagedClusterSecurityProfile withAzureKeyVaultKms(AzureKeyVaultKms azureKeyVaultKms) {
        this.azureKeyVaultKms = azureKeyVaultKms;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (defender() != null) {
            defender().validate();
        }
        if (azureKeyVaultKms() != null) {
            azureKeyVaultKms().validate();
        }
    }
}
