// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Data used when creating a target resource from a source resource. */
@Fluent
public final class CreationData {
    /*
     * This is the ARM ID of the source object to be used to create the target object.
     */
    @JsonProperty(value = "sourceResourceId")
    private String sourceResourceId;

    /** Creates an instance of CreationData class. */
    public CreationData() {
    }

    /**
     * Get the sourceResourceId property: This is the ARM ID of the source object to be used to create the target
     * object.
     *
     * @return the sourceResourceId value.
     */
    public String sourceResourceId() {
        return this.sourceResourceId;
    }

    /**
     * Set the sourceResourceId property: This is the ARM ID of the source object to be used to create the target
     * object.
     *
     * @param sourceResourceId the sourceResourceId value to set.
     * @return the CreationData object itself.
     */
    public CreationData withSourceResourceId(String sourceResourceId) {
        this.sourceResourceId = sourceResourceId;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
