// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.models;

import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collection;

/** Tells whether the cluster is Running or Stopped. */
public final class Code extends ExpandableStringEnum<Code> {
    /** Static value Running for Code. */
    public static final Code RUNNING = fromString("Running");

    /** Static value Stopped for Code. */
    public static final Code STOPPED = fromString("Stopped");

    /**
     * Creates or finds a Code from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding Code.
     */
    @JsonCreator
    public static Code fromString(String name) {
        return fromString(name, Code.class);
    }

    /**
     * Gets known Code values.
     *
     * @return known Code values.
     */
    public static Collection<Code> values() {
        return values(Code.class);
    }
}
