// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.containerservice.models.EndpointDependency;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** Egress endpoints which AKS agent nodes connect to for common purpose. */
@Fluent
public final class OutboundEnvironmentEndpointInner {
    /*
     * The category of endpoints accessed by the AKS agent node, e.g. azure-resource-management, apiserver, etc.
     */
    @JsonProperty(value = "category")
    private String category;

    /*
     * The endpoints that AKS agent nodes connect to
     */
    @JsonProperty(value = "endpoints")
    private List<EndpointDependency> endpoints;

    /** Creates an instance of OutboundEnvironmentEndpointInner class. */
    public OutboundEnvironmentEndpointInner() {
    }

    /**
     * Get the category property: The category of endpoints accessed by the AKS agent node, e.g.
     * azure-resource-management, apiserver, etc.
     *
     * @return the category value.
     */
    public String category() {
        return this.category;
    }

    /**
     * Set the category property: The category of endpoints accessed by the AKS agent node, e.g.
     * azure-resource-management, apiserver, etc.
     *
     * @param category the category value to set.
     * @return the OutboundEnvironmentEndpointInner object itself.
     */
    public OutboundEnvironmentEndpointInner withCategory(String category) {
        this.category = category;
        return this;
    }

    /**
     * Get the endpoints property: The endpoints that AKS agent nodes connect to.
     *
     * @return the endpoints value.
     */
    public List<EndpointDependency> endpoints() {
        return this.endpoints;
    }

    /**
     * Set the endpoints property: The endpoints that AKS agent nodes connect to.
     *
     * @param endpoints the endpoints value to set.
     * @return the OutboundEnvironmentEndpointInner object itself.
     */
    public OutboundEnvironmentEndpointInner withEndpoints(List<EndpointDependency> endpoints) {
        this.endpoints = endpoints;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (endpoints() != null) {
            endpoints().forEach(e -> e.validate());
        }
    }
}
