// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.containerservice.fluent.models.SnapshotInner;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** The response from the List Snapshots operation. */
@Fluent
public final class SnapshotListResult {
    /*
     * The list of snapshots.
     */
    @JsonProperty(value = "value")
    private List<SnapshotInner> value;

    /*
     * The URL to get the next set of snapshot results.
     */
    @JsonProperty(value = "nextLink", access = JsonProperty.Access.WRITE_ONLY)
    private String nextLink;

    /**
     * Get the value property: The list of snapshots.
     *
     * @return the value value.
     */
    public List<SnapshotInner> value() {
        return this.value;
    }

    /**
     * Set the value property: The list of snapshots.
     *
     * @param value the value value to set.
     * @return the SnapshotListResult object itself.
     */
    public SnapshotListResult withValue(List<SnapshotInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: The URL to get the next set of snapshot results.
     *
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }
}
