// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.models;

import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collection;

/**
 * The OS disk type to be used for machines in the agent pool.
 *
 * <p>The default is 'Ephemeral' if the VM supports it and has a cache disk larger than the requested OSDiskSizeGB.
 * Otherwise, defaults to 'Managed'. May not be changed after creation. For more information see [Ephemeral
 * OS](https://docs.microsoft.com/azure/aks/cluster-configuration#ephemeral-os).
 */
public final class OSDiskType extends ExpandableStringEnum<OSDiskType> {
    /** Static value Managed for OSDiskType. */
    public static final OSDiskType MANAGED = fromString("Managed");

    /** Static value Ephemeral for OSDiskType. */
    public static final OSDiskType EPHEMERAL = fromString("Ephemeral");

    /**
     * Creates or finds a OSDiskType from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding OSDiskType.
     */
    @JsonCreator
    public static OSDiskType fromString(String name) {
        return fromString(name, OSDiskType.class);
    }

    /**
     * Gets known OSDiskType values.
     *
     * @return known OSDiskType values.
     */
    public static Collection<OSDiskType> values() {
        return values(OSDiskType.class);
    }
}
