// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.models;

import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collection;

/** Defines values for WorkloadRuntime. */
public final class WorkloadRuntime extends ExpandableStringEnum<WorkloadRuntime> {
    /** Static value OCIContainer for WorkloadRuntime. */
    public static final WorkloadRuntime OCICONTAINER = fromString("OCIContainer");

    /** Static value WasmWasi for WorkloadRuntime. */
    public static final WorkloadRuntime WASM_WASI = fromString("WasmWasi");

    /**
     * Creates or finds a WorkloadRuntime from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding WorkloadRuntime.
     */
    @JsonCreator
    public static WorkloadRuntime fromString(String name) {
        return fromString(name, WorkloadRuntime.class);
    }

    /** @return known WorkloadRuntime values. */
    public static Collection<WorkloadRuntime> values() {
        return values(WorkloadRuntime.class);
    }
}
