// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.fluent.models;

import com.azure.core.annotation.Immutable;
import com.azure.resourcemanager.containerservice.models.CredentialResult;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** The list credential result response. */
@Immutable
public final class CredentialResultsInner {
    /*
     * Base64-encoded Kubernetes configuration file.
     */
    @JsonProperty(value = "kubeconfigs", access = JsonProperty.Access.WRITE_ONLY)
    private List<CredentialResult> kubeconfigs;

    /**
     * Get the kubeconfigs property: Base64-encoded Kubernetes configuration file.
     *
     * @return the kubeconfigs value.
     */
    public List<CredentialResult> kubeconfigs() {
        return this.kubeconfigs;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (kubeconfigs() != null) {
            kubeconfigs().forEach(e -> e.validate());
        }
    }
}
