// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.fluent;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.resourcemanager.containerservice.fluent.models.OrchestratorVersionProfileListResultInner;
import reactor.core.publisher.Mono;

/** An instance of this class provides access to all the operations defined in ContainerServicesClient. */
public interface ContainerServicesClient {
    /**
     * Gets a list of supported orchestrators in the specified subscription. The operation returns properties of each
     * orchestrator including version, available upgrades and whether that version or upgrades are in preview.
     *
     * @param location The name of a supported Azure region.
     * @param resourceType resource type for which the list of orchestrators needs to be returned.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of supported orchestrators in the specified subscription along with {@link Response} on successful
     *     completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<OrchestratorVersionProfileListResultInner>> listOrchestratorsWithResponseAsync(
        String location, String resourceType);

    /**
     * Gets a list of supported orchestrators in the specified subscription. The operation returns properties of each
     * orchestrator including version, available upgrades and whether that version or upgrades are in preview.
     *
     * @param location The name of a supported Azure region.
     * @param resourceType resource type for which the list of orchestrators needs to be returned.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of supported orchestrators in the specified subscription on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<OrchestratorVersionProfileListResultInner> listOrchestratorsAsync(String location, String resourceType);

    /**
     * Gets a list of supported orchestrators in the specified subscription. The operation returns properties of each
     * orchestrator including version, available upgrades and whether that version or upgrades are in preview.
     *
     * @param location The name of a supported Azure region.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of supported orchestrators in the specified subscription on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<OrchestratorVersionProfileListResultInner> listOrchestratorsAsync(String location);

    /**
     * Gets a list of supported orchestrators in the specified subscription. The operation returns properties of each
     * orchestrator including version, available upgrades and whether that version or upgrades are in preview.
     *
     * @param location The name of a supported Azure region.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of supported orchestrators in the specified subscription.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    OrchestratorVersionProfileListResultInner listOrchestrators(String location);

    /**
     * Gets a list of supported orchestrators in the specified subscription. The operation returns properties of each
     * orchestrator including version, available upgrades and whether that version or upgrades are in preview.
     *
     * @param location The name of a supported Azure region.
     * @param resourceType resource type for which the list of orchestrators needs to be returned.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of supported orchestrators in the specified subscription along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<OrchestratorVersionProfileListResultInner> listOrchestratorsWithResponse(
        String location, String resourceType, Context context);
}
