/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerregistry.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.containerregistry.models.SetValue;
import com.azure.resourcemanager.containerregistry.models.StepType;
import com.azure.resourcemanager.containerregistry.models.TaskStepUpdateParameters;
import java.io.IOException;
import java.util.List;

public final class FileTaskStepUpdateParameters
extends TaskStepUpdateParameters {
    private StepType type = StepType.FILE_TASK;
    private String taskFilePath;
    private String valuesFilePath;
    private List<SetValue> values;

    @Override
    public StepType type() {
        return this.type;
    }

    public String taskFilePath() {
        return this.taskFilePath;
    }

    public FileTaskStepUpdateParameters withTaskFilePath(String taskFilePath) {
        this.taskFilePath = taskFilePath;
        return this;
    }

    public String valuesFilePath() {
        return this.valuesFilePath;
    }

    public FileTaskStepUpdateParameters withValuesFilePath(String valuesFilePath) {
        this.valuesFilePath = valuesFilePath;
        return this;
    }

    public List<SetValue> values() {
        return this.values;
    }

    public FileTaskStepUpdateParameters withValues(List<SetValue> values) {
        this.values = values;
        return this;
    }

    @Override
    public FileTaskStepUpdateParameters withContextPath(String contextPath) {
        super.withContextPath(contextPath);
        return this;
    }

    @Override
    public FileTaskStepUpdateParameters withContextAccessToken(String contextAccessToken) {
        super.withContextAccessToken(contextAccessToken);
        return this;
    }

    @Override
    public void validate() {
        if (this.values() != null) {
            this.values().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("contextPath", this.contextPath());
        jsonWriter.writeStringField("contextAccessToken", this.contextAccessToken());
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeStringField("taskFilePath", this.taskFilePath);
        jsonWriter.writeStringField("valuesFilePath", this.valuesFilePath);
        jsonWriter.writeArrayField("values", this.values, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static FileTaskStepUpdateParameters fromJson(JsonReader jsonReader) throws IOException {
        return (FileTaskStepUpdateParameters)jsonReader.readObject(reader -> {
            FileTaskStepUpdateParameters deserializedFileTaskStepUpdateParameters = new FileTaskStepUpdateParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("contextPath".equals(fieldName)) {
                    deserializedFileTaskStepUpdateParameters.withContextPath(reader.getString());
                    continue;
                }
                if ("contextAccessToken".equals(fieldName)) {
                    deserializedFileTaskStepUpdateParameters.withContextAccessToken(reader.getString());
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedFileTaskStepUpdateParameters.type = StepType.fromString(reader.getString());
                    continue;
                }
                if ("taskFilePath".equals(fieldName)) {
                    deserializedFileTaskStepUpdateParameters.taskFilePath = reader.getString();
                    continue;
                }
                if ("valuesFilePath".equals(fieldName)) {
                    deserializedFileTaskStepUpdateParameters.valuesFilePath = reader.getString();
                    continue;
                }
                if ("values".equals(fieldName)) {
                    List values;
                    deserializedFileTaskStepUpdateParameters.values = values = reader.readArray(reader1 -> SetValue.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedFileTaskStepUpdateParameters;
        });
    }
}

