/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerregistry.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.containerregistry.fluent.TaskRunsClient;
import com.azure.resourcemanager.containerregistry.fluent.models.TaskRunInner;
import com.azure.resourcemanager.containerregistry.implementation.ContainerRegistryManagementClientImpl;
import com.azure.resourcemanager.containerregistry.models.TaskRunListResult;
import com.azure.resourcemanager.containerregistry.models.TaskRunUpdateParameters;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class TaskRunsClientImpl
implements TaskRunsClient {
    private final TaskRunsService service;
    private final ContainerRegistryManagementClientImpl client;

    TaskRunsClientImpl(ContainerRegistryManagementClientImpl client) {
        this.service = (TaskRunsService)RestProxy.create(TaskRunsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<TaskRunInner>> getWithResponseAsync(String resourceGroupName, String registryName, String taskRunName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (registryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter registryName is required and cannot be null."));
        }
        if (taskRunName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter taskRunName is required and cannot be null."));
        }
        String apiVersion = "2019-06-01-preview";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, registryName, "2019-06-01-preview", taskRunName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<TaskRunInner>> getWithResponseAsync(String resourceGroupName, String registryName, String taskRunName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (registryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter registryName is required and cannot be null."));
        }
        if (taskRunName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter taskRunName is required and cannot be null."));
        }
        String apiVersion = "2019-06-01-preview";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, registryName, "2019-06-01-preview", taskRunName, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<TaskRunInner> getAsync(String resourceGroupName, String registryName, String taskRunName) {
        return this.getWithResponseAsync(resourceGroupName, registryName, taskRunName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((TaskRunInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<TaskRunInner> getWithResponse(String resourceGroupName, String registryName, String taskRunName, Context context) {
        return (Response)this.getWithResponseAsync(resourceGroupName, registryName, taskRunName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public TaskRunInner get(String resourceGroupName, String registryName, String taskRunName) {
        return (TaskRunInner)((Object)this.getWithResponse(resourceGroupName, registryName, taskRunName, Context.NONE).getValue());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> createWithResponseAsync(String resourceGroupName, String registryName, String taskRunName, TaskRunInner taskRun) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (registryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter registryName is required and cannot be null."));
        }
        if (taskRunName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter taskRunName is required and cannot be null."));
        }
        if (taskRun == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter taskRun is required and cannot be null."));
        }
        taskRun.validate();
        String apiVersion = "2019-06-01-preview";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.create(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, registryName, "2019-06-01-preview", taskRunName, taskRun, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createWithResponseAsync(String resourceGroupName, String registryName, String taskRunName, TaskRunInner taskRun, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (registryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter registryName is required and cannot be null."));
        }
        if (taskRunName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter taskRunName is required and cannot be null."));
        }
        if (taskRun == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter taskRun is required and cannot be null."));
        }
        taskRun.validate();
        String apiVersion = "2019-06-01-preview";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.create(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, registryName, "2019-06-01-preview", taskRunName, taskRun, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<TaskRunInner>, TaskRunInner> beginCreateAsync(String resourceGroupName, String registryName, String taskRunName, TaskRunInner taskRun) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.createWithResponseAsync(resourceGroupName, registryName, taskRunName, taskRun);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)TaskRunInner.class), (Type)((Object)TaskRunInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<TaskRunInner>, TaskRunInner> beginCreateAsync(String resourceGroupName, String registryName, String taskRunName, TaskRunInner taskRun, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.createWithResponseAsync(resourceGroupName, registryName, taskRunName, taskRun, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)TaskRunInner.class), (Type)((Object)TaskRunInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<TaskRunInner>, TaskRunInner> beginCreate(String resourceGroupName, String registryName, String taskRunName, TaskRunInner taskRun) {
        return this.beginCreateAsync(resourceGroupName, registryName, taskRunName, taskRun).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<TaskRunInner>, TaskRunInner> beginCreate(String resourceGroupName, String registryName, String taskRunName, TaskRunInner taskRun, Context context) {
        return this.beginCreateAsync(resourceGroupName, registryName, taskRunName, taskRun, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<TaskRunInner> createAsync(String resourceGroupName, String registryName, String taskRunName, TaskRunInner taskRun) {
        return this.beginCreateAsync(resourceGroupName, registryName, taskRunName, taskRun).last().flatMap(arg_0 -> ((ContainerRegistryManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<TaskRunInner> createAsync(String resourceGroupName, String registryName, String taskRunName, TaskRunInner taskRun, Context context) {
        return this.beginCreateAsync(resourceGroupName, registryName, taskRunName, taskRun, context).last().flatMap(arg_0 -> ((ContainerRegistryManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public TaskRunInner create(String resourceGroupName, String registryName, String taskRunName, TaskRunInner taskRun) {
        return (TaskRunInner)((Object)this.createAsync(resourceGroupName, registryName, taskRunName, taskRun).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public TaskRunInner create(String resourceGroupName, String registryName, String taskRunName, TaskRunInner taskRun, Context context) {
        return (TaskRunInner)((Object)this.createAsync(resourceGroupName, registryName, taskRunName, taskRun, context).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String registryName, String taskRunName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (registryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter registryName is required and cannot be null."));
        }
        if (taskRunName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter taskRunName is required and cannot be null."));
        }
        String apiVersion = "2019-06-01-preview";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, registryName, "2019-06-01-preview", taskRunName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String registryName, String taskRunName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (registryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter registryName is required and cannot be null."));
        }
        if (taskRunName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter taskRunName is required and cannot be null."));
        }
        String apiVersion = "2019-06-01-preview";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, registryName, "2019-06-01-preview", taskRunName, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String registryName, String taskRunName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, registryName, taskRunName);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String registryName, String taskRunName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, registryName, taskRunName, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String registryName, String taskRunName) {
        return this.beginDeleteAsync(resourceGroupName, registryName, taskRunName).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String registryName, String taskRunName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, registryName, taskRunName, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String resourceGroupName, String registryName, String taskRunName) {
        return this.beginDeleteAsync(resourceGroupName, registryName, taskRunName).last().flatMap(arg_0 -> ((ContainerRegistryManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String registryName, String taskRunName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, registryName, taskRunName, context).last().flatMap(arg_0 -> ((ContainerRegistryManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String registryName, String taskRunName) {
        this.deleteAsync(resourceGroupName, registryName, taskRunName).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String registryName, String taskRunName, Context context) {
        this.deleteAsync(resourceGroupName, registryName, taskRunName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String registryName, String taskRunName, TaskRunUpdateParameters updateParameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (registryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter registryName is required and cannot be null."));
        }
        if (taskRunName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter taskRunName is required and cannot be null."));
        }
        if (updateParameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter updateParameters is required and cannot be null."));
        }
        updateParameters.validate();
        String apiVersion = "2019-06-01-preview";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.update(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, registryName, "2019-06-01-preview", taskRunName, updateParameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String registryName, String taskRunName, TaskRunUpdateParameters updateParameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (registryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter registryName is required and cannot be null."));
        }
        if (taskRunName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter taskRunName is required and cannot be null."));
        }
        if (updateParameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter updateParameters is required and cannot be null."));
        }
        updateParameters.validate();
        String apiVersion = "2019-06-01-preview";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.update(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, registryName, "2019-06-01-preview", taskRunName, updateParameters, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<TaskRunInner>, TaskRunInner> beginUpdateAsync(String resourceGroupName, String registryName, String taskRunName, TaskRunUpdateParameters updateParameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.updateWithResponseAsync(resourceGroupName, registryName, taskRunName, updateParameters);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)TaskRunInner.class), (Type)((Object)TaskRunInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<TaskRunInner>, TaskRunInner> beginUpdateAsync(String resourceGroupName, String registryName, String taskRunName, TaskRunUpdateParameters updateParameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.updateWithResponseAsync(resourceGroupName, registryName, taskRunName, updateParameters, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)TaskRunInner.class), (Type)((Object)TaskRunInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<TaskRunInner>, TaskRunInner> beginUpdate(String resourceGroupName, String registryName, String taskRunName, TaskRunUpdateParameters updateParameters) {
        return this.beginUpdateAsync(resourceGroupName, registryName, taskRunName, updateParameters).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<TaskRunInner>, TaskRunInner> beginUpdate(String resourceGroupName, String registryName, String taskRunName, TaskRunUpdateParameters updateParameters, Context context) {
        return this.beginUpdateAsync(resourceGroupName, registryName, taskRunName, updateParameters, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<TaskRunInner> updateAsync(String resourceGroupName, String registryName, String taskRunName, TaskRunUpdateParameters updateParameters) {
        return this.beginUpdateAsync(resourceGroupName, registryName, taskRunName, updateParameters).last().flatMap(arg_0 -> ((ContainerRegistryManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<TaskRunInner> updateAsync(String resourceGroupName, String registryName, String taskRunName, TaskRunUpdateParameters updateParameters, Context context) {
        return this.beginUpdateAsync(resourceGroupName, registryName, taskRunName, updateParameters, context).last().flatMap(arg_0 -> ((ContainerRegistryManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public TaskRunInner update(String resourceGroupName, String registryName, String taskRunName, TaskRunUpdateParameters updateParameters) {
        return (TaskRunInner)((Object)this.updateAsync(resourceGroupName, registryName, taskRunName, updateParameters).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public TaskRunInner update(String resourceGroupName, String registryName, String taskRunName, TaskRunUpdateParameters updateParameters, Context context) {
        return (TaskRunInner)((Object)this.updateAsync(resourceGroupName, registryName, taskRunName, updateParameters, context).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<TaskRunInner>> getDetailsWithResponseAsync(String resourceGroupName, String registryName, String taskRunName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (registryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter registryName is required and cannot be null."));
        }
        if (taskRunName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter taskRunName is required and cannot be null."));
        }
        String apiVersion = "2019-06-01-preview";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getDetails(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, registryName, "2019-06-01-preview", taskRunName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<TaskRunInner>> getDetailsWithResponseAsync(String resourceGroupName, String registryName, String taskRunName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (registryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter registryName is required and cannot be null."));
        }
        if (taskRunName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter taskRunName is required and cannot be null."));
        }
        String apiVersion = "2019-06-01-preview";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getDetails(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, registryName, "2019-06-01-preview", taskRunName, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<TaskRunInner> getDetailsAsync(String resourceGroupName, String registryName, String taskRunName) {
        return this.getDetailsWithResponseAsync(resourceGroupName, registryName, taskRunName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((TaskRunInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<TaskRunInner> getDetailsWithResponse(String resourceGroupName, String registryName, String taskRunName, Context context) {
        return (Response)this.getDetailsWithResponseAsync(resourceGroupName, registryName, taskRunName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public TaskRunInner getDetails(String resourceGroupName, String registryName, String taskRunName) {
        return (TaskRunInner)((Object)this.getDetailsWithResponse(resourceGroupName, registryName, taskRunName, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<TaskRunInner>> listSinglePageAsync(String resourceGroupName, String registryName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (registryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter registryName is required and cannot be null."));
        }
        String apiVersion = "2019-06-01-preview";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, registryName, "2019-06-01-preview", "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((TaskRunListResult)res.getValue()).value(), ((TaskRunListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<TaskRunInner>> listSinglePageAsync(String resourceGroupName, String registryName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (registryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter registryName is required and cannot be null."));
        }
        String apiVersion = "2019-06-01-preview";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, registryName, "2019-06-01-preview", "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((TaskRunListResult)res.getValue()).value(), ((TaskRunListResult)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<TaskRunInner> listAsync(String resourceGroupName, String registryName) {
        return new PagedFlux(() -> this.listSinglePageAsync(resourceGroupName, registryName), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<TaskRunInner> listAsync(String resourceGroupName, String registryName, Context context) {
        return new PagedFlux(() -> this.listSinglePageAsync(resourceGroupName, registryName, context), nextLink -> this.listNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<TaskRunInner> list(String resourceGroupName, String registryName) {
        return new PagedIterable(this.listAsync(resourceGroupName, registryName));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<TaskRunInner> list(String resourceGroupName, String registryName, Context context) {
        return new PagedIterable(this.listAsync(resourceGroupName, registryName, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<TaskRunInner>> listNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((TaskRunListResult)res.getValue()).value(), ((TaskRunListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<TaskRunInner>> listNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((TaskRunListResult)res.getValue()).value(), ((TaskRunListResult)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="ContainerRegistryManagementClientTaskRuns")
    public static interface TaskRunsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/taskRuns/{taskRunName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<TaskRunInner>> get(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="registryName") String var4, @QueryParam(value="api-version") String var5, @PathParam(value="taskRunName") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/taskRuns/{taskRunName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> create(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="registryName") String var4, @QueryParam(value="api-version") String var5, @PathParam(value="taskRunName") String var6, @BodyParam(value="application/json") TaskRunInner var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/taskRuns/{taskRunName}")
        @ExpectedResponses(value={200, 202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> delete(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="registryName") String var4, @QueryParam(value="api-version") String var5, @PathParam(value="taskRunName") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Patch(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/taskRuns/{taskRunName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> update(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="registryName") String var4, @QueryParam(value="api-version") String var5, @PathParam(value="taskRunName") String var6, @BodyParam(value="application/json") TaskRunUpdateParameters var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/taskRuns/{taskRunName}/listDetails")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<TaskRunInner>> getDetails(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="registryName") String var4, @QueryParam(value="api-version") String var5, @PathParam(value="taskRunName") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/taskRuns")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<TaskRunListResult>> list(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="registryName") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<TaskRunListResult>> listNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

