/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerregistry.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.containerregistry.models.EncryptionProperty;
import com.azure.resourcemanager.containerregistry.models.NetworkRuleBypassOptions;
import com.azure.resourcemanager.containerregistry.models.NetworkRuleSet;
import com.azure.resourcemanager.containerregistry.models.Policies;
import com.azure.resourcemanager.containerregistry.models.PublicNetworkAccess;
import com.azure.resourcemanager.containerregistry.models.RoleAssignmentMode;
import java.io.IOException;

public final class RegistryPropertiesUpdateParameters
implements JsonSerializable<RegistryPropertiesUpdateParameters> {
    private Boolean adminUserEnabled;
    private NetworkRuleSet networkRuleSet;
    private Policies policies;
    private EncryptionProperty encryption;
    private Boolean dataEndpointEnabled;
    private PublicNetworkAccess publicNetworkAccess;
    private NetworkRuleBypassOptions networkRuleBypassOptions;
    private Boolean networkRuleBypassAllowedForTasks;
    private Boolean anonymousPullEnabled;
    private RoleAssignmentMode roleAssignmentMode;

    public Boolean adminUserEnabled() {
        return this.adminUserEnabled;
    }

    public RegistryPropertiesUpdateParameters withAdminUserEnabled(Boolean adminUserEnabled) {
        this.adminUserEnabled = adminUserEnabled;
        return this;
    }

    public NetworkRuleSet networkRuleSet() {
        return this.networkRuleSet;
    }

    public RegistryPropertiesUpdateParameters withNetworkRuleSet(NetworkRuleSet networkRuleSet) {
        this.networkRuleSet = networkRuleSet;
        return this;
    }

    public Policies policies() {
        return this.policies;
    }

    public RegistryPropertiesUpdateParameters withPolicies(Policies policies) {
        this.policies = policies;
        return this;
    }

    public EncryptionProperty encryption() {
        return this.encryption;
    }

    public RegistryPropertiesUpdateParameters withEncryption(EncryptionProperty encryption) {
        this.encryption = encryption;
        return this;
    }

    public Boolean dataEndpointEnabled() {
        return this.dataEndpointEnabled;
    }

    public RegistryPropertiesUpdateParameters withDataEndpointEnabled(Boolean dataEndpointEnabled) {
        this.dataEndpointEnabled = dataEndpointEnabled;
        return this;
    }

    public PublicNetworkAccess publicNetworkAccess() {
        return this.publicNetworkAccess;
    }

    public RegistryPropertiesUpdateParameters withPublicNetworkAccess(PublicNetworkAccess publicNetworkAccess) {
        this.publicNetworkAccess = publicNetworkAccess;
        return this;
    }

    public NetworkRuleBypassOptions networkRuleBypassOptions() {
        return this.networkRuleBypassOptions;
    }

    public RegistryPropertiesUpdateParameters withNetworkRuleBypassOptions(NetworkRuleBypassOptions networkRuleBypassOptions) {
        this.networkRuleBypassOptions = networkRuleBypassOptions;
        return this;
    }

    public Boolean networkRuleBypassAllowedForTasks() {
        return this.networkRuleBypassAllowedForTasks;
    }

    public RegistryPropertiesUpdateParameters withNetworkRuleBypassAllowedForTasks(Boolean networkRuleBypassAllowedForTasks) {
        this.networkRuleBypassAllowedForTasks = networkRuleBypassAllowedForTasks;
        return this;
    }

    public Boolean anonymousPullEnabled() {
        return this.anonymousPullEnabled;
    }

    public RegistryPropertiesUpdateParameters withAnonymousPullEnabled(Boolean anonymousPullEnabled) {
        this.anonymousPullEnabled = anonymousPullEnabled;
        return this;
    }

    public RoleAssignmentMode roleAssignmentMode() {
        return this.roleAssignmentMode;
    }

    public RegistryPropertiesUpdateParameters withRoleAssignmentMode(RoleAssignmentMode roleAssignmentMode) {
        this.roleAssignmentMode = roleAssignmentMode;
        return this;
    }

    public void validate() {
        if (this.networkRuleSet() != null) {
            this.networkRuleSet().validate();
        }
        if (this.policies() != null) {
            this.policies().validate();
        }
        if (this.encryption() != null) {
            this.encryption().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("adminUserEnabled", this.adminUserEnabled);
        jsonWriter.writeJsonField("networkRuleSet", (JsonSerializable)this.networkRuleSet);
        jsonWriter.writeJsonField("policies", (JsonSerializable)this.policies);
        jsonWriter.writeJsonField("encryption", (JsonSerializable)this.encryption);
        jsonWriter.writeBooleanField("dataEndpointEnabled", this.dataEndpointEnabled);
        jsonWriter.writeStringField("publicNetworkAccess", this.publicNetworkAccess == null ? null : this.publicNetworkAccess.toString());
        jsonWriter.writeStringField("networkRuleBypassOptions", this.networkRuleBypassOptions == null ? null : this.networkRuleBypassOptions.toString());
        jsonWriter.writeBooleanField("networkRuleBypassAllowedForTasks", this.networkRuleBypassAllowedForTasks);
        jsonWriter.writeBooleanField("anonymousPullEnabled", this.anonymousPullEnabled);
        jsonWriter.writeStringField("roleAssignmentMode", this.roleAssignmentMode == null ? null : this.roleAssignmentMode.toString());
        return jsonWriter.writeEndObject();
    }

    public static RegistryPropertiesUpdateParameters fromJson(JsonReader jsonReader) throws IOException {
        return (RegistryPropertiesUpdateParameters)jsonReader.readObject(reader -> {
            RegistryPropertiesUpdateParameters deserializedRegistryPropertiesUpdateParameters = new RegistryPropertiesUpdateParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("adminUserEnabled".equals(fieldName)) {
                    deserializedRegistryPropertiesUpdateParameters.adminUserEnabled = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("networkRuleSet".equals(fieldName)) {
                    deserializedRegistryPropertiesUpdateParameters.networkRuleSet = NetworkRuleSet.fromJson(reader);
                    continue;
                }
                if ("policies".equals(fieldName)) {
                    deserializedRegistryPropertiesUpdateParameters.policies = Policies.fromJson(reader);
                    continue;
                }
                if ("encryption".equals(fieldName)) {
                    deserializedRegistryPropertiesUpdateParameters.encryption = EncryptionProperty.fromJson(reader);
                    continue;
                }
                if ("dataEndpointEnabled".equals(fieldName)) {
                    deserializedRegistryPropertiesUpdateParameters.dataEndpointEnabled = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("publicNetworkAccess".equals(fieldName)) {
                    deserializedRegistryPropertiesUpdateParameters.publicNetworkAccess = PublicNetworkAccess.fromString(reader.getString());
                    continue;
                }
                if ("networkRuleBypassOptions".equals(fieldName)) {
                    deserializedRegistryPropertiesUpdateParameters.networkRuleBypassOptions = NetworkRuleBypassOptions.fromString(reader.getString());
                    continue;
                }
                if ("networkRuleBypassAllowedForTasks".equals(fieldName)) {
                    deserializedRegistryPropertiesUpdateParameters.networkRuleBypassAllowedForTasks = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("anonymousPullEnabled".equals(fieldName)) {
                    deserializedRegistryPropertiesUpdateParameters.anonymousPullEnabled = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("roleAssignmentMode".equals(fieldName)) {
                    deserializedRegistryPropertiesUpdateParameters.roleAssignmentMode = RoleAssignmentMode.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRegistryPropertiesUpdateParameters;
        });
    }
}

