/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerregistry.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.containerregistry.fluent.models.PrivateEndpointConnectionInner;
import com.azure.resourcemanager.containerregistry.models.AutoGeneratedDomainNameLabelScope;
import com.azure.resourcemanager.containerregistry.models.EncryptionProperty;
import com.azure.resourcemanager.containerregistry.models.NetworkRuleBypassOptions;
import com.azure.resourcemanager.containerregistry.models.NetworkRuleSet;
import com.azure.resourcemanager.containerregistry.models.Policies;
import com.azure.resourcemanager.containerregistry.models.ProvisioningState;
import com.azure.resourcemanager.containerregistry.models.PublicNetworkAccess;
import com.azure.resourcemanager.containerregistry.models.RoleAssignmentMode;
import com.azure.resourcemanager.containerregistry.models.Status;
import com.azure.resourcemanager.containerregistry.models.ZoneRedundancy;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;

public final class RegistryProperties
implements JsonSerializable<RegistryProperties> {
    private String loginServer;
    private OffsetDateTime creationDate;
    private ProvisioningState provisioningState;
    private Status status;
    private Boolean adminUserEnabled;
    private NetworkRuleSet networkRuleSet;
    private Policies policies;
    private EncryptionProperty encryption;
    private Boolean dataEndpointEnabled;
    private List<String> dataEndpointHostNames;
    private List<PrivateEndpointConnectionInner> privateEndpointConnections;
    private PublicNetworkAccess publicNetworkAccess;
    private NetworkRuleBypassOptions networkRuleBypassOptions;
    private Boolean networkRuleBypassAllowedForTasks;
    private ZoneRedundancy zoneRedundancy;
    private Boolean anonymousPullEnabled;
    private AutoGeneratedDomainNameLabelScope autoGeneratedDomainNameLabelScope;
    private RoleAssignmentMode roleAssignmentMode;

    public String loginServer() {
        return this.loginServer;
    }

    public OffsetDateTime creationDate() {
        return this.creationDate;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public Status status() {
        return this.status;
    }

    public Boolean adminUserEnabled() {
        return this.adminUserEnabled;
    }

    public RegistryProperties withAdminUserEnabled(Boolean adminUserEnabled) {
        this.adminUserEnabled = adminUserEnabled;
        return this;
    }

    public NetworkRuleSet networkRuleSet() {
        return this.networkRuleSet;
    }

    public RegistryProperties withNetworkRuleSet(NetworkRuleSet networkRuleSet) {
        this.networkRuleSet = networkRuleSet;
        return this;
    }

    public Policies policies() {
        return this.policies;
    }

    public RegistryProperties withPolicies(Policies policies) {
        this.policies = policies;
        return this;
    }

    public EncryptionProperty encryption() {
        return this.encryption;
    }

    public RegistryProperties withEncryption(EncryptionProperty encryption) {
        this.encryption = encryption;
        return this;
    }

    public Boolean dataEndpointEnabled() {
        return this.dataEndpointEnabled;
    }

    public RegistryProperties withDataEndpointEnabled(Boolean dataEndpointEnabled) {
        this.dataEndpointEnabled = dataEndpointEnabled;
        return this;
    }

    public List<String> dataEndpointHostNames() {
        return this.dataEndpointHostNames;
    }

    public List<PrivateEndpointConnectionInner> privateEndpointConnections() {
        return this.privateEndpointConnections;
    }

    public PublicNetworkAccess publicNetworkAccess() {
        return this.publicNetworkAccess;
    }

    public RegistryProperties withPublicNetworkAccess(PublicNetworkAccess publicNetworkAccess) {
        this.publicNetworkAccess = publicNetworkAccess;
        return this;
    }

    public NetworkRuleBypassOptions networkRuleBypassOptions() {
        return this.networkRuleBypassOptions;
    }

    public RegistryProperties withNetworkRuleBypassOptions(NetworkRuleBypassOptions networkRuleBypassOptions) {
        this.networkRuleBypassOptions = networkRuleBypassOptions;
        return this;
    }

    public Boolean networkRuleBypassAllowedForTasks() {
        return this.networkRuleBypassAllowedForTasks;
    }

    public RegistryProperties withNetworkRuleBypassAllowedForTasks(Boolean networkRuleBypassAllowedForTasks) {
        this.networkRuleBypassAllowedForTasks = networkRuleBypassAllowedForTasks;
        return this;
    }

    public ZoneRedundancy zoneRedundancy() {
        return this.zoneRedundancy;
    }

    public RegistryProperties withZoneRedundancy(ZoneRedundancy zoneRedundancy) {
        this.zoneRedundancy = zoneRedundancy;
        return this;
    }

    public Boolean anonymousPullEnabled() {
        return this.anonymousPullEnabled;
    }

    public RegistryProperties withAnonymousPullEnabled(Boolean anonymousPullEnabled) {
        this.anonymousPullEnabled = anonymousPullEnabled;
        return this;
    }

    public AutoGeneratedDomainNameLabelScope autoGeneratedDomainNameLabelScope() {
        return this.autoGeneratedDomainNameLabelScope;
    }

    public RegistryProperties withAutoGeneratedDomainNameLabelScope(AutoGeneratedDomainNameLabelScope autoGeneratedDomainNameLabelScope) {
        this.autoGeneratedDomainNameLabelScope = autoGeneratedDomainNameLabelScope;
        return this;
    }

    public RoleAssignmentMode roleAssignmentMode() {
        return this.roleAssignmentMode;
    }

    public RegistryProperties withRoleAssignmentMode(RoleAssignmentMode roleAssignmentMode) {
        this.roleAssignmentMode = roleAssignmentMode;
        return this;
    }

    public void validate() {
        if (this.status() != null) {
            this.status().validate();
        }
        if (this.networkRuleSet() != null) {
            this.networkRuleSet().validate();
        }
        if (this.policies() != null) {
            this.policies().validate();
        }
        if (this.encryption() != null) {
            this.encryption().validate();
        }
        if (this.privateEndpointConnections() != null) {
            this.privateEndpointConnections().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("adminUserEnabled", this.adminUserEnabled);
        jsonWriter.writeJsonField("networkRuleSet", (JsonSerializable)this.networkRuleSet);
        jsonWriter.writeJsonField("policies", (JsonSerializable)this.policies);
        jsonWriter.writeJsonField("encryption", (JsonSerializable)this.encryption);
        jsonWriter.writeBooleanField("dataEndpointEnabled", this.dataEndpointEnabled);
        jsonWriter.writeStringField("publicNetworkAccess", this.publicNetworkAccess == null ? null : this.publicNetworkAccess.toString());
        jsonWriter.writeStringField("networkRuleBypassOptions", this.networkRuleBypassOptions == null ? null : this.networkRuleBypassOptions.toString());
        jsonWriter.writeBooleanField("networkRuleBypassAllowedForTasks", this.networkRuleBypassAllowedForTasks);
        jsonWriter.writeStringField("zoneRedundancy", this.zoneRedundancy == null ? null : this.zoneRedundancy.toString());
        jsonWriter.writeBooleanField("anonymousPullEnabled", this.anonymousPullEnabled);
        jsonWriter.writeStringField("autoGeneratedDomainNameLabelScope", this.autoGeneratedDomainNameLabelScope == null ? null : this.autoGeneratedDomainNameLabelScope.toString());
        jsonWriter.writeStringField("roleAssignmentMode", this.roleAssignmentMode == null ? null : this.roleAssignmentMode.toString());
        return jsonWriter.writeEndObject();
    }

    public static RegistryProperties fromJson(JsonReader jsonReader) throws IOException {
        return (RegistryProperties)jsonReader.readObject(reader -> {
            RegistryProperties deserializedRegistryProperties = new RegistryProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("loginServer".equals(fieldName)) {
                    deserializedRegistryProperties.loginServer = reader.getString();
                    continue;
                }
                if ("creationDate".equals(fieldName)) {
                    deserializedRegistryProperties.creationDate = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedRegistryProperties.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedRegistryProperties.status = Status.fromJson(reader);
                    continue;
                }
                if ("adminUserEnabled".equals(fieldName)) {
                    deserializedRegistryProperties.adminUserEnabled = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("networkRuleSet".equals(fieldName)) {
                    deserializedRegistryProperties.networkRuleSet = NetworkRuleSet.fromJson(reader);
                    continue;
                }
                if ("policies".equals(fieldName)) {
                    deserializedRegistryProperties.policies = Policies.fromJson(reader);
                    continue;
                }
                if ("encryption".equals(fieldName)) {
                    deserializedRegistryProperties.encryption = EncryptionProperty.fromJson(reader);
                    continue;
                }
                if ("dataEndpointEnabled".equals(fieldName)) {
                    deserializedRegistryProperties.dataEndpointEnabled = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("dataEndpointHostNames".equals(fieldName)) {
                    List dataEndpointHostNames;
                    deserializedRegistryProperties.dataEndpointHostNames = dataEndpointHostNames = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("privateEndpointConnections".equals(fieldName)) {
                    List privateEndpointConnections;
                    deserializedRegistryProperties.privateEndpointConnections = privateEndpointConnections = reader.readArray(reader1 -> PrivateEndpointConnectionInner.fromJson(reader1));
                    continue;
                }
                if ("publicNetworkAccess".equals(fieldName)) {
                    deserializedRegistryProperties.publicNetworkAccess = PublicNetworkAccess.fromString(reader.getString());
                    continue;
                }
                if ("networkRuleBypassOptions".equals(fieldName)) {
                    deserializedRegistryProperties.networkRuleBypassOptions = NetworkRuleBypassOptions.fromString(reader.getString());
                    continue;
                }
                if ("networkRuleBypassAllowedForTasks".equals(fieldName)) {
                    deserializedRegistryProperties.networkRuleBypassAllowedForTasks = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("zoneRedundancy".equals(fieldName)) {
                    deserializedRegistryProperties.zoneRedundancy = ZoneRedundancy.fromString(reader.getString());
                    continue;
                }
                if ("anonymousPullEnabled".equals(fieldName)) {
                    deserializedRegistryProperties.anonymousPullEnabled = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("autoGeneratedDomainNameLabelScope".equals(fieldName)) {
                    deserializedRegistryProperties.autoGeneratedDomainNameLabelScope = AutoGeneratedDomainNameLabelScope.fromString(reader.getString());
                    continue;
                }
                if ("roleAssignmentMode".equals(fieldName)) {
                    deserializedRegistryProperties.roleAssignmentMode = RoleAssignmentMode.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRegistryProperties;
        });
    }
}

