// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerregistry.models;

import com.azure.core.annotation.Immutable;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;

/**
 * The status detail properties of the connected registry.
 */
@Immutable
public final class StatusDetailProperties implements JsonSerializable<StatusDetailProperties> {
    /*
     * The component of the connected registry corresponding to the status.
     */
    private String type;

    /*
     * The HTTP status code.
     */
    private String code;

    /*
     * The description of the status.
     */
    private String description;

    /*
     * The timestamp of the status.
     */
    private OffsetDateTime timestamp;

    /*
     * The correlation ID of the status.
     */
    private String correlationId;

    /**
     * Creates an instance of StatusDetailProperties class.
     */
    public StatusDetailProperties() {
    }

    /**
     * Get the type property: The component of the connected registry corresponding to the status.
     * 
     * @return the type value.
     */
    public String type() {
        return this.type;
    }

    /**
     * Get the code property: The HTTP status code.
     * 
     * @return the code value.
     */
    public String code() {
        return this.code;
    }

    /**
     * Get the description property: The description of the status.
     * 
     * @return the description value.
     */
    public String description() {
        return this.description;
    }

    /**
     * Get the timestamp property: The timestamp of the status.
     * 
     * @return the timestamp value.
     */
    public OffsetDateTime timestamp() {
        return this.timestamp;
    }

    /**
     * Get the correlationId property: The correlation ID of the status.
     * 
     * @return the correlationId value.
     */
    public String correlationId() {
        return this.correlationId;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of StatusDetailProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of StatusDetailProperties if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the StatusDetailProperties.
     */
    public static StatusDetailProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            StatusDetailProperties deserializedStatusDetailProperties = new StatusDetailProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("type".equals(fieldName)) {
                    deserializedStatusDetailProperties.type = reader.getString();
                } else if ("code".equals(fieldName)) {
                    deserializedStatusDetailProperties.code = reader.getString();
                } else if ("description".equals(fieldName)) {
                    deserializedStatusDetailProperties.description = reader.getString();
                } else if ("timestamp".equals(fieldName)) {
                    deserializedStatusDetailProperties.timestamp = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("correlationId".equals(fieldName)) {
                    deserializedStatusDetailProperties.correlationId = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedStatusDetailProperties;
        });
    }
}
