// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerregistry.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * Determines registry role assignment mode.
 */
public final class RoleAssignmentMode extends ExpandableStringEnum<RoleAssignmentMode> {
    /**
     * Static value AbacRepositoryPermissions for RoleAssignmentMode.
     */
    public static final RoleAssignmentMode ABAC_REPOSITORY_PERMISSIONS = fromString("AbacRepositoryPermissions");

    /**
     * Static value LegacyRegistryPermissions for RoleAssignmentMode.
     */
    public static final RoleAssignmentMode LEGACY_REGISTRY_PERMISSIONS = fromString("LegacyRegistryPermissions");

    /**
     * Creates a new instance of RoleAssignmentMode value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public RoleAssignmentMode() {
    }

    /**
     * Creates or finds a RoleAssignmentMode from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding RoleAssignmentMode.
     */
    public static RoleAssignmentMode fromString(String name) {
        return fromString(name, RoleAssignmentMode.class);
    }

    /**
     * Gets known RoleAssignmentMode values.
     * 
     * @return known RoleAssignmentMode values.
     */
    public static Collection<RoleAssignmentMode> values() {
        return values(RoleAssignmentMode.class);
    }
}
