// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerregistry.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The activation properties of the connected registry.
 */
@Immutable
public final class ActivationProperties implements JsonSerializable<ActivationProperties> {
    /*
     * The activation status of the connected registry.
     */
    private ActivationStatus status;

    /**
     * Creates an instance of ActivationProperties class.
     */
    public ActivationProperties() {
    }

    /**
     * Get the status property: The activation status of the connected registry.
     * 
     * @return the status value.
     */
    public ActivationStatus status() {
        return this.status;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ActivationProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ActivationProperties if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ActivationProperties.
     */
    public static ActivationProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ActivationProperties deserializedActivationProperties = new ActivationProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("status".equals(fieldName)) {
                    deserializedActivationProperties.status = ActivationStatus.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedActivationProperties;
        });
    }
}
