// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerregistry.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.ProxyResource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.containerregistry.models.ActivationProperties;
import com.azure.resourcemanager.containerregistry.models.ConnectedRegistryMode;
import com.azure.resourcemanager.containerregistry.models.ConnectionState;
import com.azure.resourcemanager.containerregistry.models.GarbageCollectionProperties;
import com.azure.resourcemanager.containerregistry.models.LoggingProperties;
import com.azure.resourcemanager.containerregistry.models.LoginServerProperties;
import com.azure.resourcemanager.containerregistry.models.ParentProperties;
import com.azure.resourcemanager.containerregistry.models.ProvisioningState;
import com.azure.resourcemanager.containerregistry.models.StatusDetailProperties;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;

/**
 * An object that represents a connected registry for a container registry.
 */
@Fluent
public final class ConnectedRegistryInner extends ProxyResource {
    /*
     * The properties of the connected registry.
     */
    private ConnectedRegistryProperties innerProperties;

    /*
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    private SystemData systemData;

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /**
     * Creates an instance of ConnectedRegistryInner class.
     */
    public ConnectedRegistryInner() {
    }

    /**
     * Get the innerProperties property: The properties of the connected registry.
     * 
     * @return the innerProperties value.
     */
    private ConnectedRegistryProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the systemData property: Azure Resource Manager metadata containing createdBy and modifiedBy information.
     * 
     * @return the systemData value.
     */
    public SystemData systemData() {
        return this.systemData;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Get the provisioningState property: Provisioning state of the resource.
     * 
     * @return the provisioningState value.
     */
    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    /**
     * Get the mode property: The mode of the connected registry resource that indicates the permissions of the
     * registry.
     * 
     * @return the mode value.
     */
    public ConnectedRegistryMode mode() {
        return this.innerProperties() == null ? null : this.innerProperties().mode();
    }

    /**
     * Set the mode property: The mode of the connected registry resource that indicates the permissions of the
     * registry.
     * 
     * @param mode the mode value to set.
     * @return the ConnectedRegistryInner object itself.
     */
    public ConnectedRegistryInner withMode(ConnectedRegistryMode mode) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ConnectedRegistryProperties();
        }
        this.innerProperties().withMode(mode);
        return this;
    }

    /**
     * Get the version property: The current version of ACR runtime on the connected registry.
     * 
     * @return the version value.
     */
    public String version() {
        return this.innerProperties() == null ? null : this.innerProperties().version();
    }

    /**
     * Get the connectionState property: The current connection state of the connected registry.
     * 
     * @return the connectionState value.
     */
    public ConnectionState connectionState() {
        return this.innerProperties() == null ? null : this.innerProperties().connectionState();
    }

    /**
     * Get the lastActivityTime property: The last activity time of the connected registry.
     * 
     * @return the lastActivityTime value.
     */
    public OffsetDateTime lastActivityTime() {
        return this.innerProperties() == null ? null : this.innerProperties().lastActivityTime();
    }

    /**
     * Get the activation property: The activation properties of the connected registry.
     * 
     * @return the activation value.
     */
    public ActivationProperties activation() {
        return this.innerProperties() == null ? null : this.innerProperties().activation();
    }

    /**
     * Get the parent property: The parent of the connected registry.
     * 
     * @return the parent value.
     */
    public ParentProperties parent() {
        return this.innerProperties() == null ? null : this.innerProperties().parent();
    }

    /**
     * Set the parent property: The parent of the connected registry.
     * 
     * @param parent the parent value to set.
     * @return the ConnectedRegistryInner object itself.
     */
    public ConnectedRegistryInner withParent(ParentProperties parent) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ConnectedRegistryProperties();
        }
        this.innerProperties().withParent(parent);
        return this;
    }

    /**
     * Get the clientTokenIds property: The list of the ACR token resource IDs used to authenticate clients to the
     * connected registry.
     * 
     * @return the clientTokenIds value.
     */
    public List<String> clientTokenIds() {
        return this.innerProperties() == null ? null : this.innerProperties().clientTokenIds();
    }

    /**
     * Set the clientTokenIds property: The list of the ACR token resource IDs used to authenticate clients to the
     * connected registry.
     * 
     * @param clientTokenIds the clientTokenIds value to set.
     * @return the ConnectedRegistryInner object itself.
     */
    public ConnectedRegistryInner withClientTokenIds(List<String> clientTokenIds) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ConnectedRegistryProperties();
        }
        this.innerProperties().withClientTokenIds(clientTokenIds);
        return this;
    }

    /**
     * Get the loginServer property: The login server properties of the connected registry.
     * 
     * @return the loginServer value.
     */
    public LoginServerProperties loginServer() {
        return this.innerProperties() == null ? null : this.innerProperties().loginServer();
    }

    /**
     * Set the loginServer property: The login server properties of the connected registry.
     * 
     * @param loginServer the loginServer value to set.
     * @return the ConnectedRegistryInner object itself.
     */
    public ConnectedRegistryInner withLoginServer(LoginServerProperties loginServer) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ConnectedRegistryProperties();
        }
        this.innerProperties().withLoginServer(loginServer);
        return this;
    }

    /**
     * Get the logging property: The logging properties of the connected registry.
     * 
     * @return the logging value.
     */
    public LoggingProperties logging() {
        return this.innerProperties() == null ? null : this.innerProperties().logging();
    }

    /**
     * Set the logging property: The logging properties of the connected registry.
     * 
     * @param logging the logging value to set.
     * @return the ConnectedRegistryInner object itself.
     */
    public ConnectedRegistryInner withLogging(LoggingProperties logging) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ConnectedRegistryProperties();
        }
        this.innerProperties().withLogging(logging);
        return this;
    }

    /**
     * Get the statusDetails property: The list of current statuses of the connected registry.
     * 
     * @return the statusDetails value.
     */
    public List<StatusDetailProperties> statusDetails() {
        return this.innerProperties() == null ? null : this.innerProperties().statusDetails();
    }

    /**
     * Get the notificationsList property: The list of notifications subscription information for the connected
     * registry.
     * 
     * @return the notificationsList value.
     */
    public List<String> notificationsList() {
        return this.innerProperties() == null ? null : this.innerProperties().notificationsList();
    }

    /**
     * Set the notificationsList property: The list of notifications subscription information for the connected
     * registry.
     * 
     * @param notificationsList the notificationsList value to set.
     * @return the ConnectedRegistryInner object itself.
     */
    public ConnectedRegistryInner withNotificationsList(List<String> notificationsList) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ConnectedRegistryProperties();
        }
        this.innerProperties().withNotificationsList(notificationsList);
        return this;
    }

    /**
     * Get the garbageCollection property: The garbage collection properties of the connected registry.
     * 
     * @return the garbageCollection value.
     */
    public GarbageCollectionProperties garbageCollection() {
        return this.innerProperties() == null ? null : this.innerProperties().garbageCollection();
    }

    /**
     * Set the garbageCollection property: The garbage collection properties of the connected registry.
     * 
     * @param garbageCollection the garbageCollection value to set.
     * @return the ConnectedRegistryInner object itself.
     */
    public ConnectedRegistryInner withGarbageCollection(GarbageCollectionProperties garbageCollection) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ConnectedRegistryProperties();
        }
        this.innerProperties().withGarbageCollection(garbageCollection);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ConnectedRegistryInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ConnectedRegistryInner if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ConnectedRegistryInner.
     */
    public static ConnectedRegistryInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ConnectedRegistryInner deserializedConnectedRegistryInner = new ConnectedRegistryInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedConnectedRegistryInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedConnectedRegistryInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedConnectedRegistryInner.type = reader.getString();
                } else if ("properties".equals(fieldName)) {
                    deserializedConnectedRegistryInner.innerProperties = ConnectedRegistryProperties.fromJson(reader);
                } else if ("systemData".equals(fieldName)) {
                    deserializedConnectedRegistryInner.systemData = SystemData.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedConnectedRegistryInner;
        });
    }
}
