/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerregistry.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.containerregistry.models.BaseImageDependency;
import com.azure.resourcemanager.containerregistry.models.DockerTaskStep;
import com.azure.resourcemanager.containerregistry.models.EncodedTaskStep;
import com.azure.resourcemanager.containerregistry.models.FileTaskStep;
import com.azure.resourcemanager.containerregistry.models.StepType;
import java.io.IOException;
import java.util.List;

public class TaskStepProperties
implements JsonSerializable<TaskStepProperties> {
    private StepType type = StepType.fromString("TaskStepProperties");
    private List<BaseImageDependency> baseImageDependencies;
    private String contextPath;
    private String contextAccessToken;

    public StepType type() {
        return this.type;
    }

    public List<BaseImageDependency> baseImageDependencies() {
        return this.baseImageDependencies;
    }

    TaskStepProperties withBaseImageDependencies(List<BaseImageDependency> baseImageDependencies) {
        this.baseImageDependencies = baseImageDependencies;
        return this;
    }

    public String contextPath() {
        return this.contextPath;
    }

    public TaskStepProperties withContextPath(String contextPath) {
        this.contextPath = contextPath;
        return this;
    }

    public String contextAccessToken() {
        return this.contextAccessToken;
    }

    public TaskStepProperties withContextAccessToken(String contextAccessToken) {
        this.contextAccessToken = contextAccessToken;
        return this;
    }

    public void validate() {
        if (this.baseImageDependencies() != null) {
            this.baseImageDependencies().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeStringField("contextPath", this.contextPath);
        jsonWriter.writeStringField("contextAccessToken", this.contextAccessToken);
        return jsonWriter.writeEndObject();
    }

    public static TaskStepProperties fromJson(JsonReader jsonReader) throws IOException {
        return (TaskStepProperties)jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject();){
                Object fieldName;
                readerToUse.nextToken();
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    fieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("type".equals(fieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    }
                    readerToUse.skipChildren();
                }
                if ("FileTask".equals(discriminatorValue)) {
                    fieldName = FileTaskStep.fromJson(readerToUse.reset());
                    return fieldName;
                }
                if ("EncodedTask".equals(discriminatorValue)) {
                    fieldName = EncodedTaskStep.fromJson(readerToUse.reset());
                    return fieldName;
                }
                if ("Docker".equals(discriminatorValue)) {
                    fieldName = DockerTaskStep.fromJson(readerToUse.reset());
                    return fieldName;
                }
                fieldName = TaskStepProperties.fromJsonKnownDiscriminator(readerToUse.reset());
                return fieldName;
            }
        });
    }

    static TaskStepProperties fromJsonKnownDiscriminator(JsonReader jsonReader) throws IOException {
        return (TaskStepProperties)jsonReader.readObject(reader -> {
            TaskStepProperties deserializedTaskStepProperties = new TaskStepProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("type".equals(fieldName)) {
                    deserializedTaskStepProperties.type = StepType.fromString(reader.getString());
                    continue;
                }
                if ("baseImageDependencies".equals(fieldName)) {
                    List baseImageDependencies;
                    deserializedTaskStepProperties.baseImageDependencies = baseImageDependencies = reader.readArray(reader1 -> BaseImageDependency.fromJson(reader1));
                    continue;
                }
                if ("contextPath".equals(fieldName)) {
                    deserializedTaskStepProperties.contextPath = reader.getString();
                    continue;
                }
                if ("contextAccessToken".equals(fieldName)) {
                    deserializedTaskStepProperties.contextAccessToken = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedTaskStepProperties;
        });
    }
}

