/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerregistry.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.containerregistry.models.SyncProperties;
import java.io.IOException;

public final class ParentProperties
implements JsonSerializable<ParentProperties> {
    private String id;
    private SyncProperties syncProperties;
    private static final ClientLogger LOGGER = new ClientLogger(ParentProperties.class);

    public String id() {
        return this.id;
    }

    public ParentProperties withId(String id) {
        this.id = id;
        return this;
    }

    public SyncProperties syncProperties() {
        return this.syncProperties;
    }

    public ParentProperties withSyncProperties(SyncProperties syncProperties) {
        this.syncProperties = syncProperties;
        return this;
    }

    public void validate() {
        if (this.syncProperties() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property syncProperties in model ParentProperties"));
        }
        this.syncProperties().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("syncProperties", (JsonSerializable)this.syncProperties);
        jsonWriter.writeStringField("id", this.id);
        return jsonWriter.writeEndObject();
    }

    public static ParentProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ParentProperties)jsonReader.readObject(reader -> {
            ParentProperties deserializedParentProperties = new ParentProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("syncProperties".equals(fieldName)) {
                    deserializedParentProperties.syncProperties = SyncProperties.fromJson(reader);
                    continue;
                }
                if ("id".equals(fieldName)) {
                    deserializedParentProperties.id = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedParentProperties;
        });
    }
}

