/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerregistry.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.containerregistry.fluent.models.TaskRunInner;
import java.io.IOException;
import java.util.List;

public final class TaskRunListResult
implements JsonSerializable<TaskRunListResult> {
    private List<TaskRunInner> value;
    private String nextLink;

    public List<TaskRunInner> value() {
        return this.value;
    }

    public TaskRunListResult withValue(List<TaskRunInner> value) {
        this.value = value;
        return this;
    }

    public String nextLink() {
        return this.nextLink;
    }

    public TaskRunListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    public void validate() {
        if (this.value() != null) {
            this.value().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    public static TaskRunListResult fromJson(JsonReader jsonReader) throws IOException {
        return (TaskRunListResult)jsonReader.readObject(reader -> {
            TaskRunListResult deserializedTaskRunListResult = new TaskRunListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedTaskRunListResult.value = value = reader.readArray(reader1 -> TaskRunInner.fromJson(reader1));
                    continue;
                }
                if ("nextLink".equals(fieldName)) {
                    deserializedTaskRunListResult.nextLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedTaskRunListResult;
        });
    }
}

