/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerregistry.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.containerregistry.models.AuditLogStatus;
import com.azure.resourcemanager.containerregistry.models.LogLevel;
import java.io.IOException;

public final class LoggingProperties
implements JsonSerializable<LoggingProperties> {
    private LogLevel logLevel;
    private AuditLogStatus auditLogStatus;

    public LogLevel logLevel() {
        return this.logLevel;
    }

    public LoggingProperties withLogLevel(LogLevel logLevel) {
        this.logLevel = logLevel;
        return this;
    }

    public AuditLogStatus auditLogStatus() {
        return this.auditLogStatus;
    }

    public LoggingProperties withAuditLogStatus(AuditLogStatus auditLogStatus) {
        this.auditLogStatus = auditLogStatus;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("logLevel", this.logLevel == null ? null : this.logLevel.toString());
        jsonWriter.writeStringField("auditLogStatus", this.auditLogStatus == null ? null : this.auditLogStatus.toString());
        return jsonWriter.writeEndObject();
    }

    public static LoggingProperties fromJson(JsonReader jsonReader) throws IOException {
        return (LoggingProperties)jsonReader.readObject(reader -> {
            LoggingProperties deserializedLoggingProperties = new LoggingProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("logLevel".equals(fieldName)) {
                    deserializedLoggingProperties.logLevel = LogLevel.fromString(reader.getString());
                    continue;
                }
                if ("auditLogStatus".equals(fieldName)) {
                    deserializedLoggingProperties.auditLogStatus = AuditLogStatus.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedLoggingProperties;
        });
    }
}

