// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerregistry.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.containerregistry.fluent.models.WebhookInner;
import java.io.IOException;
import java.util.List;

/**
 * The result of a request to list webhooks for a container registry.
 */
@Fluent
public final class WebhookListResult implements JsonSerializable<WebhookListResult> {
    /*
     * The list of webhooks. Since this list may be incomplete, the nextLink field should be used to request the next
     * list of webhooks.
     */
    private List<WebhookInner> value;

    /*
     * The URI that can be used to request the next list of webhooks.
     */
    private String nextLink;

    /**
     * Creates an instance of WebhookListResult class.
     */
    public WebhookListResult() {
    }

    /**
     * Get the value property: The list of webhooks. Since this list may be incomplete, the nextLink field should be
     * used to request the next list of webhooks.
     * 
     * @return the value value.
     */
    public List<WebhookInner> value() {
        return this.value;
    }

    /**
     * Set the value property: The list of webhooks. Since this list may be incomplete, the nextLink field should be
     * used to request the next list of webhooks.
     * 
     * @param value the value value to set.
     * @return the WebhookListResult object itself.
     */
    public WebhookListResult withValue(List<WebhookInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: The URI that can be used to request the next list of webhooks.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: The URI that can be used to request the next list of webhooks.
     * 
     * @param nextLink the nextLink value to set.
     * @return the WebhookListResult object itself.
     */
    public WebhookListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of WebhookListResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of WebhookListResult if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the WebhookListResult.
     */
    public static WebhookListResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            WebhookListResult deserializedWebhookListResult = new WebhookListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<WebhookInner> value = reader.readArray(reader1 -> WebhookInner.fromJson(reader1));
                    deserializedWebhookListResult.value = value;
                } else if ("nextLink".equals(fieldName)) {
                    deserializedWebhookListResult.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedWebhookListResult;
        });
    }
}
