// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerregistry.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.containerregistry.fluent.models.TokenUpdateProperties;
import java.io.IOException;

/**
 * The parameters for updating a token.
 */
@Fluent
public final class TokenUpdateParameters implements JsonSerializable<TokenUpdateParameters> {
    /*
     * The properties of the token update parameters.
     */
    private TokenUpdateProperties innerProperties;

    /**
     * Creates an instance of TokenUpdateParameters class.
     */
    public TokenUpdateParameters() {
    }

    /**
     * Get the innerProperties property: The properties of the token update parameters.
     * 
     * @return the innerProperties value.
     */
    private TokenUpdateProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the scopeMapId property: The resource ID of the scope map to which the token will be associated with.
     * 
     * @return the scopeMapId value.
     */
    public String scopeMapId() {
        return this.innerProperties() == null ? null : this.innerProperties().scopeMapId();
    }

    /**
     * Set the scopeMapId property: The resource ID of the scope map to which the token will be associated with.
     * 
     * @param scopeMapId the scopeMapId value to set.
     * @return the TokenUpdateParameters object itself.
     */
    public TokenUpdateParameters withScopeMapId(String scopeMapId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new TokenUpdateProperties();
        }
        this.innerProperties().withScopeMapId(scopeMapId);
        return this;
    }

    /**
     * Get the status property: The status of the token example enabled or disabled.
     * 
     * @return the status value.
     */
    public TokenStatus status() {
        return this.innerProperties() == null ? null : this.innerProperties().status();
    }

    /**
     * Set the status property: The status of the token example enabled or disabled.
     * 
     * @param status the status value to set.
     * @return the TokenUpdateParameters object itself.
     */
    public TokenUpdateParameters withStatus(TokenStatus status) {
        if (this.innerProperties() == null) {
            this.innerProperties = new TokenUpdateProperties();
        }
        this.innerProperties().withStatus(status);
        return this;
    }

    /**
     * Get the credentials property: The credentials that can be used for authenticating the token.
     * 
     * @return the credentials value.
     */
    public TokenCredentialsProperties credentials() {
        return this.innerProperties() == null ? null : this.innerProperties().credentials();
    }

    /**
     * Set the credentials property: The credentials that can be used for authenticating the token.
     * 
     * @param credentials the credentials value to set.
     * @return the TokenUpdateParameters object itself.
     */
    public TokenUpdateParameters withCredentials(TokenCredentialsProperties credentials) {
        if (this.innerProperties() == null) {
            this.innerProperties = new TokenUpdateProperties();
        }
        this.innerProperties().withCredentials(credentials);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of TokenUpdateParameters from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of TokenUpdateParameters if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the TokenUpdateParameters.
     */
    public static TokenUpdateParameters fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            TokenUpdateParameters deserializedTokenUpdateParameters = new TokenUpdateParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("properties".equals(fieldName)) {
                    deserializedTokenUpdateParameters.innerProperties = TokenUpdateProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedTokenUpdateParameters;
        });
    }
}
