// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerregistry.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The properties of the source code repository.
 */
@Fluent
public final class SourceProperties implements JsonSerializable<SourceProperties> {
    /*
     * The type of source control service.
     */
    private SourceControlType sourceControlType;

    /*
     * The full URL to the source code repository
     */
    private String repositoryUrl;

    /*
     * The branch name of the source code.
     */
    private String branch;

    /*
     * The authorization properties for accessing the source code repository and to set up
     * webhooks for notifications.
     */
    private AuthInfo sourceControlAuthProperties;

    /**
     * Creates an instance of SourceProperties class.
     */
    public SourceProperties() {
    }

    /**
     * Get the sourceControlType property: The type of source control service.
     * 
     * @return the sourceControlType value.
     */
    public SourceControlType sourceControlType() {
        return this.sourceControlType;
    }

    /**
     * Set the sourceControlType property: The type of source control service.
     * 
     * @param sourceControlType the sourceControlType value to set.
     * @return the SourceProperties object itself.
     */
    public SourceProperties withSourceControlType(SourceControlType sourceControlType) {
        this.sourceControlType = sourceControlType;
        return this;
    }

    /**
     * Get the repositoryUrl property: The full URL to the source code repository.
     * 
     * @return the repositoryUrl value.
     */
    public String repositoryUrl() {
        return this.repositoryUrl;
    }

    /**
     * Set the repositoryUrl property: The full URL to the source code repository.
     * 
     * @param repositoryUrl the repositoryUrl value to set.
     * @return the SourceProperties object itself.
     */
    public SourceProperties withRepositoryUrl(String repositoryUrl) {
        this.repositoryUrl = repositoryUrl;
        return this;
    }

    /**
     * Get the branch property: The branch name of the source code.
     * 
     * @return the branch value.
     */
    public String branch() {
        return this.branch;
    }

    /**
     * Set the branch property: The branch name of the source code.
     * 
     * @param branch the branch value to set.
     * @return the SourceProperties object itself.
     */
    public SourceProperties withBranch(String branch) {
        this.branch = branch;
        return this;
    }

    /**
     * Get the sourceControlAuthProperties property: The authorization properties for accessing the source code
     * repository and to set up
     * webhooks for notifications.
     * 
     * @return the sourceControlAuthProperties value.
     */
    public AuthInfo sourceControlAuthProperties() {
        return this.sourceControlAuthProperties;
    }

    /**
     * Set the sourceControlAuthProperties property: The authorization properties for accessing the source code
     * repository and to set up
     * webhooks for notifications.
     * 
     * @param sourceControlAuthProperties the sourceControlAuthProperties value to set.
     * @return the SourceProperties object itself.
     */
    public SourceProperties withSourceControlAuthProperties(AuthInfo sourceControlAuthProperties) {
        this.sourceControlAuthProperties = sourceControlAuthProperties;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (sourceControlType() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property sourceControlType in model SourceProperties"));
        }
        if (repositoryUrl() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property repositoryUrl in model SourceProperties"));
        }
        if (sourceControlAuthProperties() != null) {
            sourceControlAuthProperties().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(SourceProperties.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("sourceControlType",
            this.sourceControlType == null ? null : this.sourceControlType.toString());
        jsonWriter.writeStringField("repositoryUrl", this.repositoryUrl);
        jsonWriter.writeStringField("branch", this.branch);
        jsonWriter.writeJsonField("sourceControlAuthProperties", this.sourceControlAuthProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SourceProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SourceProperties if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the SourceProperties.
     */
    public static SourceProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SourceProperties deserializedSourceProperties = new SourceProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("sourceControlType".equals(fieldName)) {
                    deserializedSourceProperties.sourceControlType = SourceControlType.fromString(reader.getString());
                } else if ("repositoryUrl".equals(fieldName)) {
                    deserializedSourceProperties.repositoryUrl = reader.getString();
                } else if ("branch".equals(fieldName)) {
                    deserializedSourceProperties.branch = reader.getString();
                } else if ("sourceControlAuthProperties".equals(fieldName)) {
                    deserializedSourceProperties.sourceControlAuthProperties = AuthInfo.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedSourceProperties;
        });
    }
}
